package ar.com.sdd.debin.io;

import ar.com.sdd.debin.entity.Respuesta;
import ar.com.sdd.debin.entity.Vendedor;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;

@JsonIgnoreProperties(ignoreUnknown=true)
@JsonInclude(JsonInclude.Include.NON_NULL)
public class ConsultarVendedorResponse {

    private Respuesta respuesta;
    private Vendedor vendedor;

    public ConsultarVendedorResponse() {
    }

    public Respuesta getRespuesta() {
        return respuesta;
    }

    public void setRespuesta(Respuesta respuesta) {
        this.respuesta = respuesta;
    }

    public Vendedor getVendedor() {
        return vendedor;
    }

    public void setVendedor(Vendedor vendedor) {
        this.vendedor = vendedor;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;

        ConsultarVendedorResponse that = (ConsultarVendedorResponse) o;

        if (respuesta != null ? !respuesta.equals(that.respuesta) : that.respuesta != null) return false;
        return vendedor != null ? vendedor.equals(that.vendedor) : that.vendedor == null;
    }

    @Override
    public int hashCode() {
        int result = respuesta != null ? respuesta.hashCode() : 0;
        result = 31 * result + (vendedor != null ? vendedor.hashCode() : 0);
        return result;
    }

    @Override
    public String toString() {
        return "ConsultarVendedorResponse [" +
                "respuesta=" + respuesta +
                ", vendedor=" + vendedor +
                ']';
    }
}
