package ar.com.sdd.debin.io;

import ar.com.sdd.debin.entity.Estado;
import ar.com.sdd.debin.entity.Respuesta;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;

@JsonIgnoreProperties(ignoreUnknown=true)
@JsonInclude(JsonInclude.Include.NON_NULL)
public class EstablecerModoBancoResponse {

    private Estado estado;
    private Respuesta respuesta;

    public EstablecerModoBancoResponse() {
    }

    public EstablecerModoBancoResponse(Estado estado) {
        this.estado = estado;
    }

    public Estado getEstado() {
        return estado;
    }

    public void setEstado(Estado estado) {
        this.estado = estado;
    }

    public Respuesta getRespuesta() {
        return respuesta;
    }

    public void setRespuesta(Respuesta respuesta) {
        this.respuesta = respuesta;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;

        EstablecerModoBancoResponse that = (EstablecerModoBancoResponse) o;

        if (estado != null ? !estado.equals(that.estado) : that.estado != null) return false;
        return respuesta != null ? respuesta.equals(that.respuesta) : that.respuesta == null;
    }

    @Override
    public int hashCode() {
        int result = estado != null ? estado.hashCode() : 0;
        result = 31 * result + (respuesta != null ? respuesta.hashCode() : 0);
        return result;
    }

    @Override
    public String toString() {
        return "EstablecerModoBancoResponse [" +
                "estado=" + estado +
                ", respuesta=" + respuesta +
                ']';
    }
}
