package ar.com.sdd.debin.io.apibancos;

import ar.com.sdd.debin.entity.DebinPendiente;
import ar.com.sdd.debin.entity.Evaluacion;
import ar.com.sdd.debin.entity.Operacion;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;

@JsonIgnoreProperties(ignoreUnknown=true)
@JsonInclude(Include.NON_NULL)
public class AvisoDebinPendienteRequest {

	private Operacion operacion;
	private DebinPendiente debin;
	private Boolean preautorizado;
	private Evaluacion evaluacion;

	public Operacion getOperacion() {
		return operacion;
	}

	public void setOperacion(Operacion operacion) {
		this.operacion = operacion;
	}

	public DebinPendiente getDebin() {
		return debin;
	}

	public void setDebin(DebinPendiente debin) {
		this.debin = debin;
	}

    public Boolean getPreautorizado() {
        return preautorizado;
    }

    public void setPreautorizado(Boolean preautorizado) {
        this.preautorizado = preautorizado;
    }

    public Evaluacion getEvaluacion() {
        return evaluacion;
    }

    public void setEvaluacion(Evaluacion evaluacion) {
        this.evaluacion = evaluacion;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;

        AvisoDebinPendienteRequest that = (AvisoDebinPendienteRequest) o;

        if (operacion != null ? !operacion.equals(that.operacion) : that.operacion != null) return false;
        if (debin != null ? !debin.equals(that.debin) : that.debin != null) return false;
        if (preautorizado != null ? !preautorizado.equals(that.preautorizado) : that.preautorizado != null)
            return false;
        return evaluacion != null ? evaluacion.equals(that.evaluacion) : that.evaluacion == null;
    }

    @Override
    public int hashCode() {
        int result = operacion != null ? operacion.hashCode() : 0;
        result = 31 * result + (debin != null ? debin.hashCode() : 0);
        result = 31 * result + (preautorizado != null ? preautorizado.hashCode() : 0);
        result = 31 * result + (evaluacion != null ? evaluacion.hashCode() : 0);
        return result;
    }

    @Override
    public String toString() {
        return "AvisoDebinPendienteRequest [" +
                "operacion=" + operacion +
                ", debin=" + debin +
                ", preautorizado=" + preautorizado +
                ", evaluacion=" + evaluacion +
                ']';
    }
}
