package ar.com.sdd.debin.io.apibancos;

import ar.com.sdd.debin.entity.*;
import ar.com.sdd.debin.util.ManyMillisecondsDateDeserializer;
import ar.com.sdd.debin.util.ManyMillisecondsDateSerializer;
import com.fasterxml.jackson.annotation.JsonFormat;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;

import java.util.Date;

@JsonIgnoreProperties(ignoreUnknown=true)
@JsonInclude(Include.NON_NULL)
public class CreditoRequest {

	private Objeto objeto;
	private Credito credito;
	private Debito debito;
	private String concepto;
	private String idUsuario;
	private String idComprobante;
	private Importe importe;
	private Integer mismoTitular;
    private DatosGenerador datosGenerador;

    @JsonDeserialize(using = ManyMillisecondsDateDeserializer.class)
    @JsonSerialize(using = ManyMillisecondsDateSerializer.class)
	private Date fechaHora;

    @JsonFormat(shape=JsonFormat.Shape.STRING, pattern="yyyy-MM-dd", timezone = "GMT-03:00")
	private Date fechaNegocio;
	private String ori_trx;
	private String ori_terminal;
	private String ori_adicional;

	public Objeto getObjeto() {
		return objeto;
	}

	public void setObjeto(Objeto objeto) {
		this.objeto = objeto;
	}

	public Credito getCredito() {
		return credito;
	}

	public void setCredito(Credito credito) {
		this.credito = credito;
	}

	public Debito getDebito() {
		return debito;
	}

	public void setDebito(Debito debito) {
		this.debito = debito;
	}

    public Importe getImporte() {
        return importe;
    }

    public void setImporte(Importe importe) {
        this.importe = importe;
    }

    public Date getFechaHora() {
        return fechaHora;
    }

    public void setFechaHora(Date fechaHora) {
        this.fechaHora = fechaHora;
    }

    public Date getFechaNegocio() {
        return fechaNegocio;
    }

    public void setFechaNegocio(Date fechaNegocio) {
        this.fechaNegocio = fechaNegocio;
    }

    public String getOri_trx() {
		return ori_trx;
	}

	public void setOri_trx(String ori_trx) {
		this.ori_trx = ori_trx;
	}

	public String getOri_terminal() {
		return ori_terminal;
	}

	public void setOri_terminal(String ori_terminal) {
		this.ori_terminal = ori_terminal;
	}

	public String getOri_adicional() {
		return ori_adicional;
	}

	public void setOri_adicional(String ori_adicional) {
		this.ori_adicional = ori_adicional;
	}

    public String getConcepto() {
        return concepto;
    }

    public void setConcepto(String concepto) {
        this.concepto = concepto;
    }

    public String getIdUsuario() {
        return idUsuario;
    }

    public void setIdUsuario(String idUsuario) {
        this.idUsuario = idUsuario;
    }

    public String getIdComprobante() {
        return idComprobante;
    }

    public void setIdComprobante(String idComprobante) {
        this.idComprobante = idComprobante;
    }

    public Integer getMismoTitular() {
        return mismoTitular;
    }

    public void setMismoTitular(Integer mismoTitular) {
        this.mismoTitular = mismoTitular;
    }

    public DatosGenerador getDatosGenerador() {
        return datosGenerador;
    }

    public void setDatosGenerador(DatosGenerador datosGenerador) {
        this.datosGenerador = datosGenerador;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;

        CreditoRequest that = (CreditoRequest) o;

        if (objeto != null ? !objeto.equals(that.objeto) : that.objeto != null) return false;
        if (credito != null ? !credito.equals(that.credito) : that.credito != null) return false;
        if (debito != null ? !debito.equals(that.debito) : that.debito != null) return false;
        if (concepto != null ? !concepto.equals(that.concepto) : that.concepto != null) return false;
        if (idUsuario != null ? !idUsuario.equals(that.idUsuario) : that.idUsuario != null) return false;
        if (idComprobante != null ? !idComprobante.equals(that.idComprobante) : that.idComprobante != null)
            return false;
        if (importe != null ? !importe.equals(that.importe) : that.importe != null) return false;
        if (mismoTitular != null ? !mismoTitular.equals(that.mismoTitular) : that.mismoTitular != null) return false;
        if (datosGenerador != null ? !datosGenerador.equals(that.datosGenerador) : that.datosGenerador != null)
            return false;
        if (fechaHora != null ? !fechaHora.equals(that.fechaHora) : that.fechaHora != null) return false;
        if (fechaNegocio != null ? !fechaNegocio.equals(that.fechaNegocio) : that.fechaNegocio != null) return false;
        if (ori_trx != null ? !ori_trx.equals(that.ori_trx) : that.ori_trx != null) return false;
        if (ori_terminal != null ? !ori_terminal.equals(that.ori_terminal) : that.ori_terminal != null) return false;
        return ori_adicional != null ? ori_adicional.equals(that.ori_adicional) : that.ori_adicional == null;
    }

    @Override
    public int hashCode() {
        int result = objeto != null ? objeto.hashCode() : 0;
        result = 31 * result + (credito != null ? credito.hashCode() : 0);
        result = 31 * result + (debito != null ? debito.hashCode() : 0);
        result = 31 * result + (concepto != null ? concepto.hashCode() : 0);
        result = 31 * result + (idUsuario != null ? idUsuario.hashCode() : 0);
        result = 31 * result + (idComprobante != null ? idComprobante.hashCode() : 0);
        result = 31 * result + (importe != null ? importe.hashCode() : 0);
        result = 31 * result + (mismoTitular != null ? mismoTitular.hashCode() : 0);
        result = 31 * result + (datosGenerador != null ? datosGenerador.hashCode() : 0);
        result = 31 * result + (fechaHora != null ? fechaHora.hashCode() : 0);
        result = 31 * result + (fechaNegocio != null ? fechaNegocio.hashCode() : 0);
        result = 31 * result + (ori_trx != null ? ori_trx.hashCode() : 0);
        result = 31 * result + (ori_terminal != null ? ori_terminal.hashCode() : 0);
        result = 31 * result + (ori_adicional != null ? ori_adicional.hashCode() : 0);
        return result;
    }

    @Override
    public String toString() {
        return "CreditoRequest [" +
                "objeto=" + objeto +
                ", credito=" + credito +
                ", debito=" + debito +
                ", concepto=" + concepto +
                ", idUsuario=" + idUsuario +
                ", idComprobante=" + idComprobante +
                ", importe=" + importe +
                ", mismoTitular=" + mismoTitular +
                ", datosGenerador=" + datosGenerador +
                ", fechaHora=" + fechaHora +
                ", fechaNegocio=" + fechaNegocio +
                ", ori_trx=" + ori_trx +
                ", ori_terminal=" + ori_terminal +
                ", ori_adicional=" + ori_adicional +
                ']';
    }
}
