package ar.com.sdd.debin.io;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;

@JsonIgnoreProperties(ignoreUnknown=true)
@JsonInclude(JsonInclude.Include.NON_NULL)
public class ConsultarCompradorRequest {

    private String cuit;

    public ConsultarCompradorRequest() {
    }

    public ConsultarCompradorRequest(String cuit) {
        this.cuit = cuit;
    }

    public String getCuit() {
        return cuit;
    }

    public void setCuit(String cuit) {
        this.cuit = cuit;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;

        ConsultarCompradorRequest that = (ConsultarCompradorRequest) o;

        return cuit != null ? cuit.equals(that.cuit) : that.cuit == null;
    }

    @Override
    public int hashCode() {
        return cuit != null ? cuit.hashCode() : 0;
    }

    @Override
    public String toString() {
        return "ConsultarCompradorRequest [" +
                "cuit=" + cuit +
                ']';
    }
}
