package ar.com.sdd.debin.io;


import ar.com.sdd.debin.entity.Comprador;
import ar.com.sdd.debin.entity.Respuesta;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;

@JsonIgnoreProperties(ignoreUnknown=true)
@JsonInclude(JsonInclude.Include.NON_NULL)
public class ConsultarCompradorResponse {

    private Respuesta respuesta;
    private Comprador comprador;

    public ConsultarCompradorResponse() {
    }

    public Respuesta getRespuesta() {
        return respuesta;
    }

    public void setRespuesta(Respuesta respuesta) {
        this.respuesta = respuesta;
    }

    public Comprador getComprador() {
        return comprador;
    }

    public void setComprador(Comprador comprador) {
        this.comprador = comprador;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;

        ConsultarCompradorResponse that = (ConsultarCompradorResponse) o;

        if (respuesta != null ? !respuesta.equals(that.respuesta) : that.respuesta != null) return false;
        return comprador != null ? comprador.equals(that.comprador) : that.comprador == null;
    }

    @Override
    public int hashCode() {
        int result = respuesta != null ? respuesta.hashCode() : 0;
        result = 31 * result + (comprador != null ? comprador.hashCode() : 0);
        return result;
    }

    @Override
    public String toString() {
        return "ConsultarCompradorResponse [" +
                "respuesta=" + respuesta +
                ", comprador=" + comprador +
                ']';
    }
}
