package ar.com.sdd.debin.io;

import ar.com.sdd.debin.entity.Respuesta;
import ar.com.sdd.debin.entity.VendedorConsumos;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;

@JsonIgnoreProperties(ignoreUnknown = true)
@JsonInclude(JsonInclude.Include.NON_NULL)
public class ConsumosConsultaVendedorResponse {

    private Respuesta respuesta;
    private VendedorConsumos vendedorConsumos;

    public ConsumosConsultaVendedorResponse() {}

    public Respuesta getRespuesta() {
        return respuesta;
    }

    public void setRespuesta(Respuesta respuesta) {
        this.respuesta = respuesta;
    }

    public VendedorConsumos getVendedorConsumos() {
        return vendedorConsumos;
    }

    public void setVendedorConsumos(VendedorConsumos vendedorConsumos) {
        this.vendedorConsumos = vendedorConsumos;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;

        ConsumosConsultaVendedorResponse that = (ConsumosConsultaVendedorResponse) o;

        if (respuesta != null ? !respuesta.equals(that.respuesta) : that.respuesta != null) return false;
        return vendedorConsumos != null ? vendedorConsumos.equals(that.vendedorConsumos) : that.vendedorConsumos == null;
    }

    @Override
    public int hashCode() {
        int result = respuesta != null ? respuesta.hashCode() : 0;
        result = 31 * result + (vendedorConsumos != null ? vendedorConsumos.hashCode() : 0);
        return result;
    }

    @Override
    public String toString() {
        return "ConsumosConsultaVendedorResponse [" +
                "respuesta=" + respuesta +
                ", vendedorConsumos=" + vendedorConsumos +
                ']';
    }
}
