package ar.com.sdd.debin.io;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;

@JsonIgnoreProperties(ignoreUnknown=true)
@JsonInclude(JsonInclude.Include.NON_NULL)
public class QuitarCompradorResponse {

    private String descripcion;
    /**
     00: Ok
     63: Entidad Incorrecta
     93: Comprador no adherido
     06: CBU mal formulado
     10: Cuit mal formulado
     90: Error de Sistema
     */
    private String codigo;

    public QuitarCompradorResponse() {
    }

    public String getDescripcion() {
        return descripcion;
    }

    public void setDescripcion(String descripcion) {
        this.descripcion = descripcion;
    }

    public String getCodigo() {
        return codigo;
    }

    public void setCodigo(String codigo) {
        this.codigo = codigo;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;

        QuitarCompradorResponse that = (QuitarCompradorResponse) o;

        if (descripcion != null ? !descripcion.equals(that.descripcion) : that.descripcion != null) return false;
        return codigo != null ? codigo.equals(that.codigo) : that.codigo == null;
    }

    @Override
    public int hashCode() {
        int result = descripcion != null ? descripcion.hashCode() : 0;
        result = 31 * result + (codigo != null ? codigo.hashCode() : 0);
        return result;
    }

    @Override
    public String toString() {
        return "QuitarCompradorResponse [" +
                "descripcion=" + descripcion +
                ", codigo=" + codigo +
                ']';
    }
}
