package ar.com.sdd.debin.io;

import ar.com.sdd.debin.entity.Comprador;
import ar.com.sdd.debin.entity.Creacion;
import ar.com.sdd.debin.entity.Estado;
import ar.com.sdd.debin.entity.Listado;
import ar.com.sdd.debin.entity.Vendedor;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;

@JsonIgnoreProperties(ignoreUnknown = true)
@JsonInclude(JsonInclude.Include.NON_NULL)
public class VendedorRecurrenciaListaVendedorRequest {

    private Listado listado;
    private Comprador comprador;
    private Vendedor vendedor;
    private Estado estado;
    private Creacion creacion;

    public VendedorRecurrenciaListaVendedorRequest() {
    }

    public Listado getListado() {
        return listado;
    }

    public void setListado(Listado listado) {
        this.listado = listado;
    }

    public Comprador getComprador() {
        return comprador;
    }

    public void setComprador(Comprador comprador) {
        this.comprador = comprador;
    }

    public Vendedor getVendedor() {
        return vendedor;
    }

    public void setVendedor(Vendedor vendedor) {
        this.vendedor = vendedor;
    }

    public Estado getEstado() {
        return estado;
    }

    public void setEstado(Estado estado) {
        this.estado = estado;
    }

    public Creacion getCreacion() {
        return creacion;
    }

    public void setCreacion(Creacion creacion) {
        this.creacion = creacion;
    }

    @Override
    public String toString() {
        return "VendedorRecurrenciaListaVendedorRequest [" +
                "listado=" + listado +
                ", comprador=" + comprador +
                ", vendedor=" + vendedor +
                ", estado=" + estado +
                ", creacion=" + creacion +
                ']';
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;

        VendedorRecurrenciaListaVendedorRequest that = (VendedorRecurrenciaListaVendedorRequest) o;

        if (listado != null ? !listado.equals(that.listado) : that.listado != null) return false;
        if (comprador != null ? !comprador.equals(that.comprador) : that.comprador != null) return false;
        if (vendedor != null ? !vendedor.equals(that.vendedor) : that.vendedor != null) return false;
        if (estado != null ? !estado.equals(that.estado) : that.estado != null) return false;
        return creacion != null ? creacion.equals(that.creacion) : that.creacion == null;
    }

    @Override
    public int hashCode() {
        int result = listado != null ? listado.hashCode() : 0;
        result = 31 * result + (comprador != null ? comprador.hashCode() : 0);
        result = 31 * result + (vendedor != null ? vendedor.hashCode() : 0);
        result = 31 * result + (estado != null ? estado.hashCode() : 0);
        result = 31 * result + (creacion != null ? creacion.hashCode() : 0);
        return result;
    }
}
