package ar.com.sdd.debin.entity;

import ar.com.sdd.debin.core.DebinConst;
import ar.com.sdd.debin.util.ManyMillisecondsDateDeserializer;
import ar.com.sdd.debin.util.ManyMillisecondsDateSerializer;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;

import java.math.BigDecimal;
import java.util.Date;

@JsonIgnoreProperties(ignoreUnknown = true)
public class Detalle {

    private DebinConst.Concepto concepto;
    private Integer idUsuario;
    private Integer idComprobante;
    private DebinConst.Moneda moneda;
    private BigDecimal importe;
    private Boolean devolucion;
    private String idOperacionOriginal;
    private Integer tiempoExpiracion;
    private String descripcion;

    @JsonDeserialize(using = ManyMillisecondsDateDeserializer.class)
    @JsonSerialize(using = ManyMillisecondsDateSerializer.class)
    private Date fecha;

    @JsonDeserialize(using = ManyMillisecondsDateDeserializer.class)
    @JsonSerialize(using = ManyMillisecondsDateSerializer.class)
    private Date fechaExpiracion;

    private String oriTrx;
    private String oriTerminal;
    private String oriAdicional;
    private Integer mismoTitular;
    private String motivo;

    public DebinConst.Concepto getConcepto() {
        return concepto;
    }

    public void setConcepto(DebinConst.Concepto concepto) {
        this.concepto = concepto;
    }

    public Integer getIdUsuario() {
        return idUsuario;
    }

    public void setIdUsuario(Integer idUsuario) {
        this.idUsuario = idUsuario;
    }

    public Integer getIdComprobante() {
        return idComprobante;
    }

    public void setIdComprobante(Integer idComprobante) {
        this.idComprobante = idComprobante;
    }

    public DebinConst.Moneda getMoneda() {
        return moneda;
    }

    public void setMoneda(DebinConst.Moneda moneda) {
        this.moneda = moneda;
    }

    public BigDecimal getImporte() {
        return importe;
    }

    public void setImporte(BigDecimal importe) {
        this.importe = importe;
    }

    public Boolean getDevolucion() {
        return devolucion;
    }

    public void setDevolucion(Boolean devolucion) {
        this.devolucion = devolucion;
    }

    public String getIdOperacionOriginal() {
        return idOperacionOriginal;
    }

    public void setIdOperacionOriginal(String idOperacionOriginal) {
        this.idOperacionOriginal = idOperacionOriginal;
    }

    public Integer getTiempoExpiracion() {
        return tiempoExpiracion;
    }

    public void setTiempoExpiracion(Integer tiempoExpiracion) {
        this.tiempoExpiracion = tiempoExpiracion;
    }

    public String getDescripcion() {
        return descripcion;
    }

    public void setDescripcion(String descripcion) {
        this.descripcion = descripcion;
    }

    public Date getFecha() {
        return fecha;
    }

    public void setFecha(Date fecha) {
        this.fecha = fecha;
    }

    public Date getFechaExpiracion() {
        return fechaExpiracion;
    }

    public void setFechaExpiracion(Date fechaExpiracion) {
        this.fechaExpiracion = fechaExpiracion;
    }

    public String getOriTrx() {
        return oriTrx;
    }

    public void setOriTrx(String oriTrx) {
        this.oriTrx = oriTrx;
    }

    public String getOriTerminal() {
        return oriTerminal;
    }

    public void setOriTerminal(String oriTerminal) {
        this.oriTerminal = oriTerminal;
    }

    public String getOriAdicional() {
        return oriAdicional;
    }

    public void setOriAdicional(String oriAdicional) {
        this.oriAdicional = oriAdicional;
    }

    public Integer getMismoTitular() {
        return mismoTitular;
    }

    public void setMismoTitular(Integer mismoTitular) {
        this.mismoTitular = mismoTitular;
    }

    public String getMotivo() {
        return motivo;
    }

    public void setMotivo(String motivo) {
        this.motivo = motivo;
    }

    @Override
    public String toString() {
        return "Detalle [" +
                "concepto=" + concepto +
                ", idUsuario=" + idUsuario +
                ", idComprobante=" + idComprobante +
                ", moneda=" + moneda +
                ", importe=" + importe +
                ", devolucion=" + devolucion +
                ", idOperacionOriginal=" + idOperacionOriginal +
                ", tiempoExpiracion=" + tiempoExpiracion +
                ", descripcion=" + descripcion +
                ", fecha=" + fecha +
                ", fechaExpiracion=" + fechaExpiracion +
                ", oriTrx=" + oriTrx +
                ", oriTerminal=" + oriTerminal +
                ", oriAdicional=" + oriAdicional +
                ", mismoTitular=" + mismoTitular +
                ", motivo=" + motivo +
                ']';
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;

        Detalle detalle = (Detalle) o;

        if (concepto != detalle.concepto) return false;
        if (idUsuario != null ? !idUsuario.equals(detalle.idUsuario) : detalle.idUsuario != null) return false;
        if (idComprobante != null ? !idComprobante.equals(detalle.idComprobante) : detalle.idComprobante != null) return false;
        if (moneda != detalle.moneda) return false;
        if (importe != null ? !importe.equals(detalle.importe) : detalle.importe != null) return false;
        if (devolucion != null ? !devolucion.equals(detalle.devolucion) : detalle.devolucion != null) return false;
        if (idOperacionOriginal != null ? !idOperacionOriginal.equals(detalle.idOperacionOriginal) : detalle.idOperacionOriginal != null) return false;
        if (tiempoExpiracion != null ? !tiempoExpiracion.equals(detalle.tiempoExpiracion) : detalle.tiempoExpiracion != null) return false;
        if (descripcion != null ? !descripcion.equals(detalle.descripcion) : detalle.descripcion != null) return false;
        if (fecha != null ? !fecha.equals(detalle.fecha) : detalle.fecha != null) return false;
        if (fechaExpiracion != null ? !fechaExpiracion.equals(detalle.fechaExpiracion) : detalle.fechaExpiracion != null) return false;
        if (oriTrx != null ? !oriTrx.equals(detalle.oriTrx) : detalle.oriTrx != null) return false;
        if (oriTerminal != null ? !oriTerminal.equals(detalle.oriTerminal) : detalle.oriTerminal != null) return false;
        if (oriAdicional != null ? !oriAdicional.equals(detalle.oriAdicional) : detalle.oriAdicional != null) return false;
        if (mismoTitular != null ? !mismoTitular.equals(detalle.mismoTitular) : detalle.mismoTitular != null) return false;
        return motivo != null ? motivo.equals(detalle.motivo) : detalle.motivo == null;
    }

    @Override
    public int hashCode() {
        int result = concepto != null ? concepto.hashCode() : 0;
        result = 31 * result + (idUsuario != null ? idUsuario.hashCode() : 0);
        result = 31 * result + (idComprobante != null ? idComprobante.hashCode() : 0);
        result = 31 * result + (moneda != null ? moneda.hashCode() : 0);
        result = 31 * result + (importe != null ? importe.hashCode() : 0);
        result = 31 * result + (devolucion != null ? devolucion.hashCode() : 0);
        result = 31 * result + (idOperacionOriginal != null ? idOperacionOriginal.hashCode() : 0);
        result = 31 * result + (tiempoExpiracion != null ? tiempoExpiracion.hashCode() : 0);
        result = 31 * result + (descripcion != null ? descripcion.hashCode() : 0);
        result = 31 * result + (fecha != null ? fecha.hashCode() : 0);
        result = 31 * result + (fechaExpiracion != null ? fechaExpiracion.hashCode() : 0);
        result = 31 * result + (oriTrx != null ? oriTrx.hashCode() : 0);
        result = 31 * result + (oriTerminal != null ? oriTerminal.hashCode() : 0);
        result = 31 * result + (oriAdicional != null ? oriAdicional.hashCode() : 0);
        result = 31 * result + (mismoTitular != null ? mismoTitular.hashCode() : 0);
        result = 31 * result + (motivo != null ? motivo.hashCode() : 0);
        return result;
    }
}
