package ar.com.sdd.debin.entity;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;

@JsonIgnoreProperties(ignoreUnknown=true)
public class Vendedor {

    private String codigo;
    private String titular;
    private Cuenta cuenta;
    private String cuit;
    private String cbu;
    private String banco;
    private String sucursal;
    private String terminal;
    private String endpoint;
    private Contacto contacto;
    private Integer loteId;
    private Boolean recurrencia;

    public Vendedor() {

    }

    /**
     * Convenience method para pruebas
     *
     * @param cuit
     * @param cbu
     * @param banco
     * @param sucursal
     * @param terminal
     */
    public Vendedor(String cuit, String cbu, String banco, String sucursal, String terminal) {
       this.cuit = cuit;
       this.cbu = cbu;
       this.banco = banco;
       this.sucursal = sucursal;
       this.terminal = terminal;
    }

    public String getCodigo() {
        return codigo;
    }

    public void setCodigo(String codigo) {
        this.codigo = codigo;
    }

    public String getTitular() {
        return titular;
    }

    public void setTitular(String titular) {
        this.titular = titular;
    }

    public Cuenta getCuenta() {
        return cuenta;
    }

    public void setCuenta(Cuenta cuenta) {
        this.cuenta = cuenta;
    }

    public String getCuit() {
        return cuit;
    }

    public void setCuit(String cuit) {
        this.cuit = cuit;
    }

    public String getCbu() {
        return cbu;
    }

    public void setCbu(String cbu) {
        this.cbu = cbu;
    }

    public String getBanco() {
        return banco;
    }

    public void setBanco(String banco) {
        this.banco = banco;
    }

    public String getSucursal() {
        return sucursal;
    }

    public void setSucursal(String sucursal) {
        this.sucursal = sucursal;
    }

    public String getTerminal() {
        return terminal;
    }

    public void setTerminal(String terminal) {
        this.terminal = terminal;
    }

    public String getEndpoint() {
        return endpoint;
    }

    public void setEndpoint(String endpoint) {
        this.endpoint = endpoint;
    }

    public Contacto getContacto() {
        return contacto;
    }

    public void setContacto(Contacto contacto) {
        this.contacto = contacto;
    }

    public Integer getLoteId() {
        return loteId;
    }

    public void setLoteId(Integer loteId) {
        this.loteId = loteId;
    }

    public Boolean getRecurrencia() {
        return recurrencia;
    }

    public void setRecurrencia(Boolean recurrencia) {
        this.recurrencia = recurrencia;
    }

    @Override
    public String toString() {
        return "Vendedor ["
                + ((codigo != null) ? "codigo=" + codigo + ", " : "")
                + ((titular != null) ? "titular=" + titular + ", " : "")
                + ((cuenta != null) ? "cuenta=" + cuenta + ", " : "")
                + ((cuit != null) ? "cuit=" + cuit + ", " : "")
                + ((cbu != null) ? "cbu=" + cbu + ", " : "")
                + ((banco != null) ? "banco=" + banco + ", " : "")
                + ((sucursal != null) ? "sucursal=" + sucursal + ", " : "")
                + ((terminal != null) ? "terminal=" + terminal + ", " : "")
                + ((endpoint != null) ? "endpoint=" + endpoint + ", " : "")
                + ((contacto != null) ? "contacto=" + contacto + ", " : "")
                + ((loteId != null) ? "loteId=" + loteId + ", " : "")
                + ((recurrencia != null) ? "recurrencia=" + recurrencia : "")
                + "]";
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;

        Vendedor vendedor = (Vendedor) o;

        if (codigo != null ? !codigo.equals(vendedor.codigo) : vendedor.codigo != null) return false;
        if (titular != null ? !titular.equals(vendedor.titular) : vendedor.titular != null) return false;
        if (cuenta != null ? !cuenta.equals(vendedor.cuenta) : vendedor.cuenta != null) return false;
        if (cuit != null ? !cuit.equals(vendedor.cuit) : vendedor.cuit != null) return false;
        if (cbu != null ? !cbu.equals(vendedor.cbu) : vendedor.cbu != null) return false;
        if (banco != null ? !banco.equals(vendedor.banco) : vendedor.banco != null) return false;
        if (sucursal != null ? !sucursal.equals(vendedor.sucursal) : vendedor.sucursal != null) return false;
        if (terminal != null ? !terminal.equals(vendedor.terminal) : vendedor.terminal != null) return false;
        if (endpoint != null ? !endpoint.equals(vendedor.endpoint) : vendedor.endpoint != null) return false;
        if (contacto != null ? !contacto.equals(vendedor.contacto) : vendedor.contacto != null) return false;
        if (loteId != null ? !loteId.equals(vendedor.loteId) : vendedor.loteId != null) return false;
        return recurrencia != null ? recurrencia.equals(vendedor.recurrencia) : vendedor.recurrencia == null;
    }

    @Override
    public int hashCode() {
        int result = codigo != null ? codigo.hashCode() : 0;
        result = 31 * result + (titular != null ? titular.hashCode() : 0);
        result = 31 * result + (cuenta != null ? cuenta.hashCode() : 0);
        result = 31 * result + (cuit != null ? cuit.hashCode() : 0);
        result = 31 * result + (cbu != null ? cbu.hashCode() : 0);
        result = 31 * result + (banco != null ? banco.hashCode() : 0);
        result = 31 * result + (sucursal != null ? sucursal.hashCode() : 0);
        result = 31 * result + (terminal != null ? terminal.hashCode() : 0);
        result = 31 * result + (endpoint != null ? endpoint.hashCode() : 0);
        result = 31 * result + (contacto != null ? contacto.hashCode() : 0);
        result = 31 * result + (loteId != null ? loteId.hashCode() : 0);
        result = 31 * result + (recurrencia != null ? recurrencia.hashCode() : 0);
        return result;
    }
}
