package ar.com.sdd.debin.io;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;

@JsonIgnoreProperties(ignoreUnknown=true)
@JsonInclude(JsonInclude.Include.NON_NULL)
public class ConsultarDebinRequest {

    private String debinId;

    public ConsultarDebinRequest() {
    }

    public ConsultarDebinRequest(String debinId) {
        this.debinId = debinId;
    }

    public String getDebinId() {
        return debinId;
    }

    public void setDebinId(String debinId) {
        this.debinId = debinId;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;

        ConsultarDebinRequest that = (ConsultarDebinRequest) o;

        return debinId != null ? debinId.equals(that.debinId) : that.debinId == null;
    }

    @Override
    public int hashCode() {
        return debinId != null ? debinId.hashCode() : 0;
    }

    @Override
    public String toString() {
        return "ConsultarDebinRequest [" +
                "debinId=" + debinId +
                ']';
    }
}
