
package ar.com.sdd.debin.io;


import ar.com.sdd.debin.entity.Debin;
import ar.com.sdd.debin.entity.Evaluacion;
import ar.com.sdd.debin.entity.Respuesta;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;

@JsonIgnoreProperties(ignoreUnknown=true)
@JsonInclude(JsonInclude.Include.NON_NULL)
public class CrearDebinResponse {

    private Respuesta respuesta;
    private Debin debin;
    private Evaluacion evaluacion;

    public CrearDebinResponse() {
    }

    public Respuesta getRespuesta() {
        return respuesta;
    }

    public void setRespuesta(Respuesta respuesta) {
        this.respuesta = respuesta;
    }

    public Debin getDebin() {
        return debin;
    }

    public void setDebin(Debin debin) {
        this.debin = debin;
    }

    public Evaluacion getEvaluacion() {
        return evaluacion;
    }

    public void setEvaluacion(Evaluacion evaluacion) {
        this.evaluacion = evaluacion;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;

        CrearDebinResponse that = (CrearDebinResponse) o;

        if (respuesta != null ? !respuesta.equals(that.respuesta) : that.respuesta != null) return false;
        if (debin != null ? !debin.equals(that.debin) : that.debin != null) return false;
        return evaluacion != null ? evaluacion.equals(that.evaluacion) : that.evaluacion == null;
    }

    @Override
    public int hashCode() {
        int result = respuesta != null ? respuesta.hashCode() : 0;
        result = 31 * result + (debin != null ? debin.hashCode() : 0);
        result = 31 * result + (evaluacion != null ? evaluacion.hashCode() : 0);
        return result;
    }

    @Override
    public String toString() {
        return "CrearDebinResponse [" +
                "respuesta=" + respuesta +
                ", debin=" + debin +
                ", evaluacion=" + evaluacion +
                ']';
    }
}
