package ar.com.sdd.debin.io;

import ar.com.sdd.debin.entity.Respuesta;
import ar.com.sdd.debin.entity.VendedorLimites;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;

@JsonIgnoreProperties(ignoreUnknown = true)
@JsonInclude(JsonInclude.Include.NON_NULL)
public class LimitesConsultaVendedorResponse {

    private Respuesta respuesta;
    private VendedorLimites vendedorLimites;

    public LimitesConsultaVendedorResponse() {
    }

    public Respuesta getRespuesta() {
        return respuesta;
    }

    public void setRespuesta(Respuesta respuesta) {
        this.respuesta = respuesta;
    }

    public VendedorLimites getVendedorLimites() {
        return vendedorLimites;
    }

    public void setVendedorLimites(VendedorLimites vendedorLimites) {
        this.vendedorLimites = vendedorLimites;
    }

    @Override
    public String toString() {
        return "LimitesConsultaVendedorResponse ["
                + ((respuesta != null) ? "respuesta=" + respuesta + ", " : "")
                + ((vendedorLimites != null) ? "vendedorLimites=" + vendedorLimites : "")
                + "]";
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;

        LimitesConsultaVendedorResponse that = (LimitesConsultaVendedorResponse) o;

        if (respuesta != null ? !respuesta.equals(that.respuesta) : that.respuesta != null) return false;
        return vendedorLimites != null ? vendedorLimites.equals(that.vendedorLimites) : that.vendedorLimites == null;
    }

    @Override
    public int hashCode() {
        int result = respuesta != null ? respuesta.hashCode() : 0;
        result = 31 * result + (vendedorLimites != null ? vendedorLimites.hashCode() : 0);
        return result;
    }
}
