package ar.com.sdd.debin.entity;

import javax.json.bind.annotation.JsonbNillable;

@JsonbNillable
public class Credito {

    private String cuit;
    private String banco;
    private String sucursal;
    private String titular;
    private Cuenta cuenta;

    public String getCuit() {
        return cuit;
    }

    public void setCuit(String cuit) {
        this.cuit = cuit;
    }

    public String getBanco() {
        return banco;
    }

    public void setBanco(String banco) {
        this.banco = banco;
    }

    public String getSucursal() {
        return sucursal;
    }

    public void setSucursal(String sucursal) {
        this.sucursal = sucursal;
    }

    public Cuenta getCuenta() {
        return cuenta;
    }

    public void setCuenta(Cuenta cuenta) {
        this.cuenta = cuenta;
    }

    public String getTitular() {
        return titular;
    }

    public void setTitular(String titular) {
        this.titular = titular;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;

        Credito credito = (Credito) o;

        if (cuit != null ? !cuit.equals(credito.cuit) : credito.cuit != null) return false;
        if (banco != null ? !banco.equals(credito.banco) : credito.banco != null) return false;
        if (sucursal != null ? !sucursal.equals(credito.sucursal) : credito.sucursal != null) return false;
        if (titular != null ? !titular.equals(credito.titular) : credito.titular != null) return false;
        return cuenta != null ? cuenta.equals(credito.cuenta) : credito.cuenta == null;
    }

    @Override
    public int hashCode() {
        int result = cuit != null ? cuit.hashCode() : 0;
        result = 31 * result + (banco != null ? banco.hashCode() : 0);
        result = 31 * result + (sucursal != null ? sucursal.hashCode() : 0);
        result = 31 * result + (titular != null ? titular.hashCode() : 0);
        result = 31 * result + (cuenta != null ? cuenta.hashCode() : 0);
        return result;
    }

    @Override
    public String toString() {
        return "Credito [" +
                "cuit=" + cuit +
                ", banco=" + banco +
                ", sucursal=" + sucursal +
                ", titular=" + titular +
                ", cuenta=" + cuenta +
                ']';
    }
}
