package ar.com.sdd.debin.entity;

import ar.com.sdd.debin.core.DebinConst;
import ar.com.sdd.debin.util.ManyMillisecondsDateDeserializer;
import ar.com.sdd.debin.util.ManyMillisecondsDateSerializer;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import javax.json.bind.annotation.JsonbTypeDeserializer;
import javax.json.bind.annotation.JsonbTypeSerializer;

import java.math.BigDecimal;
import java.util.Date;

@JsonIgnoreProperties(ignoreUnknown=true)
public class Debin {

    private String id;
    private Estado estado;

    @JsonbTypeDeserializer(ManyMillisecondsDateDeserializer.class)
    @JsonbTypeSerializer(ManyMillisecondsDateSerializer.class)
    private Date addDt;

    @JsonbTypeDeserializer(ManyMillisecondsDateDeserializer.class)
    @JsonbTypeSerializer(ManyMillisecondsDateSerializer.class)
    private Date fechaExpiracion;

    private Creacion creacion;
    private Vendedor vendedor;
    private Comprador comprador;
    private DebinConst.Moneda moneda;
    private BigDecimal importe;
    private String concepto;

    @JsonbTypeDeserializer(ManyMillisecondsDateDeserializer.class)
    @JsonbTypeSerializer(ManyMillisecondsDateSerializer.class)
    private Date vencimiento;

    private BigDecimal montoPeriodo;
    private BigDecimal montoXDebin;
    private Integer cantidad;
    private String detalle;
    private String periodo;

    public String getId() {
        return id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public Estado getEstado() {
        return estado;
    }

    public void setEstado(Estado estado) {
        this.estado = estado;
    }

    public Date getAddDt() {
        return addDt;
    }

    public void setAddDt(Date addDt) {
        this.addDt = addDt;
    }

    public Date getFechaExpiracion() {
        return fechaExpiracion;
    }

    public void setFechaExpiracion(Date fechaExpiracion) {
        this.fechaExpiracion = fechaExpiracion;
    }

    public Creacion getCreacion() {
        return creacion;
    }

    public void setCreacion(Creacion creacion) {
        this.creacion = creacion;
    }

    public Vendedor getVendedor() {
        return vendedor;
    }

    public void setVendedor(Vendedor vendedor) {
        this.vendedor = vendedor;
    }

    public Comprador getComprador() {
        return comprador;
    }

    public void setComprador(Comprador comprador) {
        this.comprador = comprador;
    }

    public DebinConst.Moneda getMoneda() {
        return moneda;
    }

    public void setMoneda(DebinConst.Moneda moneda) {
        this.moneda = moneda;
    }

    public BigDecimal getImporte() {
        return importe;
    }

    public void setImporte(BigDecimal importe) {
        this.importe = importe;
    }

    public String getConcepto() {
        return concepto;
    }

    public void setConcepto(String concepto) {
        this.concepto = concepto;
    }

    public Date getVencimiento() {
        return vencimiento;
    }

    public void setVencimiento(Date vencimiento) {
        this.vencimiento = vencimiento;
    }

    public BigDecimal getMontoPeriodo() {
        return montoPeriodo;
    }

    public void setMontoPeriodo(BigDecimal montoPeriodo) {
        this.montoPeriodo = montoPeriodo;
    }

    public BigDecimal getMontoXDebin() {
        return montoXDebin;
    }

    public void setMontoXDebin(BigDecimal montoXDebin) {
        this.montoXDebin = montoXDebin;
    }

    public Integer getCantidad() {
        return cantidad;
    }

    public void setCantidad(Integer cantidad) {
        this.cantidad = cantidad;
    }

    public String getDetalle() {
        return detalle;
    }

    public void setDetalle(String detalle) {
        this.detalle = detalle;
    }

    public String getPeriodo() {
        return periodo;
    }

    public void setPeriodo(String periodo) {
        this.periodo = periodo;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;

        Debin debin = (Debin) o;

        if (id != null ? !id.equals(debin.id) : debin.id != null) return false;
        if (estado != null ? !estado.equals(debin.estado) : debin.estado != null) return false;
        if (addDt != null ? !addDt.equals(debin.addDt) : debin.addDt != null) return false;
        if (fechaExpiracion != null ? !fechaExpiracion.equals(debin.fechaExpiracion) : debin.fechaExpiracion != null)
            return false;
        if (creacion != null ? !creacion.equals(debin.creacion) : debin.creacion != null) return false;
        if (vendedor != null ? !vendedor.equals(debin.vendedor) : debin.vendedor != null) return false;
        if (comprador != null ? !comprador.equals(debin.comprador) : debin.comprador != null) return false;
        if (moneda != debin.moneda) return false;
        if (importe != null ? !importe.equals(debin.importe) : debin.importe != null) return false;
        if (concepto != null ? !concepto.equals(debin.concepto) : debin.concepto != null) return false;
        if (vencimiento != null ? !vencimiento.equals(debin.vencimiento) : debin.vencimiento != null) return false;
        if (montoPeriodo != null ? !montoPeriodo.equals(debin.montoPeriodo) : debin.montoPeriodo != null) return false;
        if (montoXDebin != null ? !montoXDebin.equals(debin.montoXDebin) : debin.montoXDebin != null) return false;
        if (cantidad != null ? !cantidad.equals(debin.cantidad) : debin.cantidad != null) return false;
        if (detalle != null ? !detalle.equals(debin.detalle) : debin.detalle != null) return false;
        return periodo != null ? periodo.equals(debin.periodo) : debin.periodo == null;
    }

    @Override
    public int hashCode() {
        int result = id != null ? id.hashCode() : 0;
        result = 31 * result + (estado != null ? estado.hashCode() : 0);
        result = 31 * result + (addDt != null ? addDt.hashCode() : 0);
        result = 31 * result + (fechaExpiracion != null ? fechaExpiracion.hashCode() : 0);
        result = 31 * result + (creacion != null ? creacion.hashCode() : 0);
        result = 31 * result + (vendedor != null ? vendedor.hashCode() : 0);
        result = 31 * result + (comprador != null ? comprador.hashCode() : 0);
        result = 31 * result + (moneda != null ? moneda.hashCode() : 0);
        result = 31 * result + (importe != null ? importe.hashCode() : 0);
        result = 31 * result + (concepto != null ? concepto.hashCode() : 0);
        result = 31 * result + (vencimiento != null ? vencimiento.hashCode() : 0);
        result = 31 * result + (montoPeriodo != null ? montoPeriodo.hashCode() : 0);
        result = 31 * result + (montoXDebin != null ? montoXDebin.hashCode() : 0);
        result = 31 * result + (cantidad != null ? cantidad.hashCode() : 0);
        result = 31 * result + (detalle != null ? detalle.hashCode() : 0);
        result = 31 * result + (periodo != null ? periodo.hashCode() : 0);
        return result;
    }

    @Override
    public String toString() {
        return "Debin [" +
                "id=" + id +
                ", estado=" + estado +
                ", addDt=" + addDt +
                ", fechaExpiracion=" + fechaExpiracion +
                ", creacion=" + creacion +
                ", vendedor=" + vendedor +
                ", comprador=" + comprador +
                ", moneda=" + moneda +
                ", importe=" + importe +
                ", concepto=" + concepto +
                ", vencimiento=" + vencimiento +
                ", montoPeriodo=" + montoPeriodo +
                ", montoXDebin=" + montoXDebin +
                ", cantidad=" + cantidad +
                ", detalle=" + detalle +
                ", periodo=" + periodo +
                ']';
    }
}
