package ar.com.sdd.debin.io;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import javax.json.bind.annotation.JsonbNillable;

@JsonIgnoreProperties(ignoreUnknown=true)
@JsonbNillable
public class ConsultarVendedorRequest {

    private String cuit;

    public ConsultarVendedorRequest() {
    }

    public ConsultarVendedorRequest(String cuit) {
        this.cuit = cuit;
    }

    public String getCuit() {
        return cuit;
    }

    public void setCuit(String cuit) {
        this.cuit = cuit;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;

        ConsultarVendedorRequest that = (ConsultarVendedorRequest) o;

        return cuit != null ? cuit.equals(that.cuit) : that.cuit == null;
    }

    @Override
    public int hashCode() {
        return cuit != null ? cuit.hashCode() : 0;
    }

    @Override
    public String toString() {
        return "ConsultarVendedorRequest [" +
                "cuit=" + cuit +
                ']';
    }
}
