package ar.com.sdd.debin.io;


import ar.com.sdd.debin.core.DebinException;
import ar.com.sdd.debin.entity.Operacion;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import javax.json.bind.annotation.JsonbNillable;
import org.apache.commons.lang3.StringUtils;

@JsonIgnoreProperties(ignoreUnknown = true)
@JsonbNillable
public class CrearDebinRequest implements RequestValidation {

    private Operacion operacion;

    public CrearDebinRequest() {
    }

    public CrearDebinRequest(Operacion operacion) {
        this.operacion = operacion;
    }

    public Operacion getOperacion() {
        return operacion;
    }

    public void setOperacion(Operacion operacion) {
        this.operacion = operacion;
    }

    @Override
    public void validate() throws DebinException {
        StringBuilder errors = new StringBuilder();
        if (operacion == null) {
            errors.append("|operacion null");
        } else {

            //Vendedor
            if (operacion.getVendedor() == null) {
                errors.append("|vendedor null");
            } else {
                if (StringUtils.isEmpty(operacion.getVendedor().getCuit())) {
                    errors.append("|vendedor.cuit empty");
                }
                if (StringUtils.isEmpty(operacion.getVendedor().getCbu())) {
                    errors.append("|vendedor.cbu empty");
                }
                if (StringUtils.isEmpty(operacion.getVendedor().getBanco())) {
                    errors.append("|vendedor.banco empty");
                }
                if (StringUtils.isEmpty(operacion.getVendedor().getTerminal())) {
                    errors.append("|vendedor.terminal empty");
                }
            }

            //Comprador
            if (operacion.getComprador() == null) {
                errors.append("|comprador null");
            } else {
                if (StringUtils.isEmpty(operacion.getComprador().getCuit())) {
                    errors.append("|comprador.cuit empty");
                }

                if (operacion.getComprador().getCuenta() == null) {
                    errors.append("|comprador.cuenta null");
                } else {
                    if (StringUtils.isEmpty(operacion.getComprador().getCuenta().getCbu())) {
                        errors.append("|comprador.cuenta.cbu empty");
                    }
                    if (StringUtils.isEmpty(operacion.getComprador().getCuenta().getAlias())) {
                        errors.append("|comprador.cuenta.alias empty");
                    }
                }
            }

            //Detalle
            if (operacion.getDetalle() == null) {
                errors.append("|detalle null");
            } else {
                if (operacion.getDetalle().getConcepto() == null) {
                    errors.append("|detalle.concepto null");
                }
                if (operacion.getDetalle().getMoneda() == null) {
                    errors.append("|detalle.moneda null");
                }
                if (operacion.getDetalle().getImporte() == null) {
                    errors.append("|detalle.importe null");
                }
                if (operacion.getDetalle().getTiempoExpiracion() == null) {
                    errors.append("|detalle.tiempoExpiracion null");
                }

                //FIXME Esto es un hack que pide Gire ya que no saben recibir idUsuario y idComprobante en null
                if (operacion.getDetalle().getIdUsuario() == null) {
                    operacion.getDetalle().setIdUsuario(0);
                }
                if (operacion.getDetalle().getIdComprobante() == null) {
                    operacion.getDetalle().setIdComprobante(0);
                }

            }
        }

        if (errors.length() > 0) {
            errors.insert(0, "Error de validacion en CrearDebinRequest:");
            throw new DebinException(errors.toString());
        }
    }

    @Override
    public String toString() {
        return "CrearDebinRequest ["
                + ((operacion != null) ? "operacion=" + operacion : "")
                + "]";
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;

        CrearDebinRequest that = (CrearDebinRequest) o;

        return operacion != null ? operacion.equals(that.operacion) : that.operacion == null;
    }

    @Override
    public int hashCode() {
        return operacion != null ? operacion.hashCode() : 0;
    }
}
