package ar.com.sdd.debin.io;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import javax.json.bind.annotation.JsonbNillable;

@JsonIgnoreProperties(ignoreUnknown=true)
@JsonbNillable
public class EliminarDebinRequest {

    private String debinId;
    private String cuit;

    public EliminarDebinRequest() {
    }

    public EliminarDebinRequest(String debinId, String cuit) {
        this.debinId = debinId;
        this.cuit = cuit;
    }

    public String getDebinId() {
        return debinId;
    }

    public void setDebinId(String debinId) {
        this.debinId = debinId;
    }

    public String getCuit() {
        return cuit;
    }

    public void setCuit(String cuit) {
        this.cuit = cuit;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;

        EliminarDebinRequest that = (EliminarDebinRequest) o;

        if (debinId != null ? !debinId.equals(that.debinId) : that.debinId != null) return false;
        return cuit != null ? cuit.equals(that.cuit) : that.cuit == null;
    }

    @Override
    public int hashCode() {
        int result = debinId != null ? debinId.hashCode() : 0;
        result = 31 * result + (cuit != null ? cuit.hashCode() : 0);
        return result;
    }

    @Override
    public String toString() {
        return "EliminarDebinRequest [" +
                "debinId=" + debinId +
                ", cuit=" + cuit +
                ']';
    }
}
