package ar.com.sdd.debin.io;

import ar.com.sdd.debin.core.DebinConst;
import ar.com.sdd.debin.entity.Respuesta;
import javax.json.bind.annotation.JsonbDateFormat;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import javax.json.bind.annotation.JsonbNillable;

import java.util.Date;

@JsonIgnoreProperties(ignoreUnknown = true)
@JsonbNillable
public class SolicitudContraCargoCompradorResponse {

    private String id;

    @JsonbDateFormat("yyyy-MM-dd")
    private Date fechaNegocio;

    private DebinConst.TipoDebin tipo;
    private Respuesta respuesta;

    public SolicitudContraCargoCompradorResponse() {
    }

    public String getId() {
        return id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public Date getFechaNegocio() {
        return fechaNegocio;
    }

    public void setFechaNegocio(Date fechaNegocio) {
        this.fechaNegocio = fechaNegocio;
    }

    public DebinConst.TipoDebin getTipo() {
        return tipo;
    }

    public void setTipo(DebinConst.TipoDebin tipo) {
        this.tipo = tipo;
    }

    public Respuesta getRespuesta() {
        return respuesta;
    }

    public void setRespuesta(Respuesta respuesta) {
        this.respuesta = respuesta;
    }

    @Override
    public String toString() {
        return "SolicitudContraCargoCompradorResponse [" +
                "id=" + id +
                ", fechaNegocio=" + fechaNegocio +
                ", tipo=" + tipo +
                ", respuesta=" + respuesta +
                ']';
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;

        SolicitudContraCargoCompradorResponse that = (SolicitudContraCargoCompradorResponse) o;

        if (id != null ? !id.equals(that.id) : that.id != null) return false;
        if (fechaNegocio != null ? !fechaNegocio.equals(that.fechaNegocio) : that.fechaNegocio != null) return false;
        if (tipo != that.tipo) return false;
        return respuesta != null ? respuesta.equals(that.respuesta) : that.respuesta == null;
    }

    @Override
    public int hashCode() {
        int result = id != null ? id.hashCode() : 0;
        result = 31 * result + (fechaNegocio != null ? fechaNegocio.hashCode() : 0);
        result = 31 * result + (tipo != null ? tipo.hashCode() : 0);
        result = 31 * result + (respuesta != null ? respuesta.hashCode() : 0);
        return result;
    }
}
