package ar.com.sdd.debin.io;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import javax.json.bind.annotation.JsonbNillable;

@JsonIgnoreProperties(ignoreUnknown = true)
@JsonbNillable
public class VendedorRecurrenciaVendedorRequest {

    private Integer id;
    private String cuit;

    public VendedorRecurrenciaVendedorRequest() {}

    public Integer getId() {
        return id;
    }

    public void setId(Integer id) {
        this.id = id;
    }

    public String getCuit() {
        return cuit;
    }

    public void setCuit(String cuit) {
        this.cuit = cuit;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;

        VendedorRecurrenciaVendedorRequest that = (VendedorRecurrenciaVendedorRequest) o;

        if (id != null ? !id.equals(that.id) : that.id != null) return false;
        return cuit != null ? cuit.equals(that.cuit) : that.cuit == null;
    }

    @Override
    public int hashCode() {
        int result = id != null ? id.hashCode() : 0;
        result = 31 * result + (cuit != null ? cuit.hashCode() : 0);
        return result;
    }

    @Override
    public String toString() {
        return "VendedorRecurrenciaVendedorRequest [" +
                "id=" + id +
                ", cuit=" + cuit +
                ']';
    }
}
