package ar.com.sdd.debin.util;

import javax.json.bind.serializer.DeserializationContext;
import javax.json.bind.serializer.JsonbDeserializer;
import javax.json.stream.JsonParser;
import javax.xml.bind.DatatypeConverter;
import java.lang.reflect.Type;
import java.util.Date;

/**
 * Deserializa el formato de fecha que envia Coelsa hacia un Date <br>
 * Ejemplo tomado de: https://kodejava.org/tag/jsondeserialize/
 */
public class ManyMillisecondsDateDeserializer implements JsonbDeserializer<Date> {

    @Override
    public Date deserialize(JsonParser jsonParser, DeserializationContext ctx, Type rtType) {
        String dateWithMillis = jsonParser.getString();

        /*
         * Este conversor, utiliza el formato XML de xsd:dateTime (http://books.xmlschemata.org/relaxng/ch19-77049.html)
         * Por ahora desde Coelsa viene como yyyy-MM-dd'T'HH:mm:ss.SSSSSSSXXX (ej: 2017-08-16T13:26:21.6849796-03:00) y este conversor lo interpreta bien
         *
         * Sino, otra forma podria ser usando:
         *         DateTimeFormatter formatter = DateTimeFormatter.ofPattern("yyyy-MM-dd'T'HH:mm:ss.SSSSSSSXXX");
         *         LocalDateTime time  = LocalDateTime.parse("2017-08-16T13:26:21.6849796-03:00", formatter);
         * pero hay que asegurarse de que se preserve el timezone
         */
        return dateWithMillis != null && !dateWithMillis.equals("") ? DatatypeConverter.parseDateTime(dateWithMillis).getTime() : null;
    }
}
