package ar.com.sdd.debin.entity;

import ar.com.sdd.debin.core.DebinConst;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;

import javax.json.bind.annotation.JsonbDateFormat;
import java.util.Date;

@JsonIgnoreProperties(ignoreUnknown = true)
public class Operacion {

    private String id;
    private DebinConst.TipoDebin tipo;
    private Comprador comprador;
    private Detalle detalle;
    private Vendedor vendedor;
    private Estado estado;
    private Boolean garantiaOk;
    private String tipoTransac;
    private Integer loteId;
    private Creacion creacion;
    private String ori_trx;
    private String ori_terminal;
    private String ori_adicional;
    private DatosGenerador datosGenerador;

    @JsonbDateFormat("yyyy-MM-dd")
    private Date fechaNegocio;

    public String getId() {
        return id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public Comprador getComprador() {
        return comprador;
    }

    public void setComprador(Comprador comprador) {
        this.comprador = comprador;
    }

    public Detalle getDetalle() {
        return detalle;
    }

    public void setDetalle(Detalle detalle) {
        this.detalle = detalle;
    }

    public Vendedor getVendedor() {
        return vendedor;
    }

    public void setVendedor(Vendedor vendedor) {
        this.vendedor = vendedor;
    }

    public Estado getEstado() {
        return estado;
    }

    public void setEstado(Estado estado) {
        this.estado = estado;
    }

    public Boolean getGarantiaOk() {
        return garantiaOk;
    }

    public void setGarantiaOk(Boolean garantiaOk) {
        this.garantiaOk = garantiaOk;
    }

    public String getTipoTransac() {
        return tipoTransac;
    }

    public void setTipoTransac(String tipoTransac) {
        this.tipoTransac = tipoTransac;
    }

    public Integer getLoteId() {
        return loteId;
    }

    public void setLoteId(Integer loteId) {
        this.loteId = loteId;
    }

    public Date getFechaNegocio() {
        return fechaNegocio;
    }

    public void setFechaNegocio(Date fechaNegocio) {
        this.fechaNegocio = fechaNegocio;
    }

    public Creacion getCreacion() {
        return creacion;
    }

    public void setCreacion(Creacion creacion) {
        this.creacion = creacion;
    }

    public DebinConst.TipoDebin getTipo() {
        return tipo;
    }

    public void setTipo(DebinConst.TipoDebin tipo) {
        this.tipo = tipo;
    }

    public String getOri_trx() {
        return ori_trx;
    }

    public void setOri_trx(String ori_trx) {
        this.ori_trx = ori_trx;
    }

    public String getOri_terminal() {
        return ori_terminal;
    }

    public void setOri_terminal(String ori_terminal) {
        this.ori_terminal = ori_terminal;
    }

    public String getOri_adicional() {
        return ori_adicional;
    }

    public void setOri_adicional(String ori_adicional) {
        this.ori_adicional = ori_adicional;
    }

    public DatosGenerador getDatosGenerador() {
        return datosGenerador;
    }

    public void setDatosGenerador(DatosGenerador datosGenerador) {
        this.datosGenerador = datosGenerador;
    }

    @Override
    public String toString() {
        return "Operacion ["
                + ((id != null) ? "id=" + id + ", " : "")
                + ((tipo != null) ? "tipo=" + tipo + ", " : "")
                + ((comprador != null) ? "comprador=" + comprador + ", " : "")
                + ((detalle != null) ? "detalle=" + detalle + ", " : "")
                + ((vendedor != null) ? "vendedor=" + vendedor + ", " : "")
                + ((estado != null) ? "estado=" + estado + ", " : "")
                + ((garantiaOk != null) ? "garantiaOk=" + garantiaOk + ", " : "")
                + ((tipoTransac != null) ? "tipoTransac=" + tipoTransac + ", " : "")
                + ((loteId != null) ? "loteId=" + loteId + ", " : "")
                + ((creacion != null) ? "creacion=" + creacion + ", " : "")
                + ((ori_trx != null) ? "ori_trx=" + ori_trx + ", " : "")
                + ((ori_terminal != null) ? "ori_terminal=" + ori_terminal + ", " : "")
                + ((ori_adicional != null) ? "ori_adicional=" + ori_adicional + ", " : "")
                + ((datosGenerador != null) ? "datosGenerador=" + datosGenerador + ", " : "")
                + ((fechaNegocio != null) ? "fechaNegocio=" + fechaNegocio : "")
                + "]";
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;

        Operacion operacion = (Operacion) o;

        if (id != null ? !id.equals(operacion.id) : operacion.id != null) return false;
        if (tipo != operacion.tipo) return false;
        if (comprador != null ? !comprador.equals(operacion.comprador) : operacion.comprador != null) return false;
        if (detalle != null ? !detalle.equals(operacion.detalle) : operacion.detalle != null) return false;
        if (vendedor != null ? !vendedor.equals(operacion.vendedor) : operacion.vendedor != null) return false;
        if (estado != null ? !estado.equals(operacion.estado) : operacion.estado != null) return false;
        if (garantiaOk != null ? !garantiaOk.equals(operacion.garantiaOk) : operacion.garantiaOk != null) return false;
        if (tipoTransac != null ? !tipoTransac.equals(operacion.tipoTransac) : operacion.tipoTransac != null) return false;
        if (loteId != null ? !loteId.equals(operacion.loteId) : operacion.loteId != null) return false;
        if (creacion != null ? !creacion.equals(operacion.creacion) : operacion.creacion != null) return false;
        if (ori_trx != null ? !ori_trx.equals(operacion.ori_trx) : operacion.ori_trx != null) return false;
        if (ori_terminal != null ? !ori_terminal.equals(operacion.ori_terminal) : operacion.ori_terminal != null) return false;
        if (ori_adicional != null ? !ori_adicional.equals(operacion.ori_adicional) : operacion.ori_adicional != null) return false;
        if (datosGenerador != null ? !datosGenerador.equals(operacion.datosGenerador) : operacion.datosGenerador != null) return false;
        return fechaNegocio != null ? fechaNegocio.equals(operacion.fechaNegocio) : operacion.fechaNegocio == null;
    }

    @Override
    public int hashCode() {
        int result = id != null ? id.hashCode() : 0;
        result = 31 * result + (tipo != null ? tipo.hashCode() : 0);
        result = 31 * result + (comprador != null ? comprador.hashCode() : 0);
        result = 31 * result + (detalle != null ? detalle.hashCode() : 0);
        result = 31 * result + (vendedor != null ? vendedor.hashCode() : 0);
        result = 31 * result + (estado != null ? estado.hashCode() : 0);
        result = 31 * result + (garantiaOk != null ? garantiaOk.hashCode() : 0);
        result = 31 * result + (tipoTransac != null ? tipoTransac.hashCode() : 0);
        result = 31 * result + (loteId != null ? loteId.hashCode() : 0);
        result = 31 * result + (creacion != null ? creacion.hashCode() : 0);
        result = 31 * result + (ori_trx != null ? ori_trx.hashCode() : 0);
        result = 31 * result + (ori_terminal != null ? ori_terminal.hashCode() : 0);
        result = 31 * result + (ori_adicional != null ? ori_adicional.hashCode() : 0);
        result = 31 * result + (datosGenerador != null ? datosGenerador.hashCode() : 0);
        result = 31 * result + (fechaNegocio != null ? fechaNegocio.hashCode() : 0);
        return result;
    }
}
