package ar.com.sdd.debin.entity;

import ar.com.sdd.debin.core.DebinConst;
import ar.com.sdd.debin.util.ManyMillisecondsDateDeserializer;
import ar.com.sdd.debin.util.ManyMillisecondsDateSerializer;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import javax.json.bind.annotation.JsonbTypeDeserializer;
import javax.json.bind.annotation.JsonbTypeSerializer;

import java.math.BigDecimal;
import java.util.Date;

@JsonIgnoreProperties(ignoreUnknown = true)
public class Operaciones {

    private String id;
    private DebinConst.TipoDebin tipo;
    private Vendedor vendedor;
    private Comprador comprador;
    private DebinConst.Moneda moneda;
    private BigDecimal importe;
    private String concepto;
    private Boolean devolucion;
    private String idOperacionOriginal;
    private Estado estado;
    @JsonbTypeDeserializer(ManyMillisecondsDateDeserializer.class)
    @JsonbTypeSerializer(ManyMillisecondsDateSerializer.class)
    private Date vencimiento;

    public Operaciones() {
    }

    public String getId() {
        return id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public DebinConst.TipoDebin getTipo() {
        return tipo;
    }

    public void setTipo(DebinConst.TipoDebin tipo) {
        this.tipo = tipo;
    }

    public Vendedor getVendedor() {
        return vendedor;
    }

    public void setVendedor(Vendedor vendedor) {
        this.vendedor = vendedor;
    }

    public Comprador getComprador() {
        return comprador;
    }

    public void setComprador(Comprador comprador) {
        this.comprador = comprador;
    }

    public DebinConst.Moneda getMoneda() {
        return moneda;
    }

    public void setMoneda(DebinConst.Moneda moneda) {
        this.moneda = moneda;
    }

    public BigDecimal getImporte() {
        return importe;
    }

    public void setImporte(BigDecimal importe) {
        this.importe = importe;
    }

    public Boolean getDevolucion() {
        return devolucion;
    }

    public void setDevolucion(Boolean devolucion) {
        this.devolucion = devolucion;
    }

    public String getIdOperacionOriginal() {
        return idOperacionOriginal;
    }

    public void setIdOperacionOriginal(String idOperacionOriginal) {
        this.idOperacionOriginal = idOperacionOriginal;
    }

    public String getConcepto() {
        return concepto;
    }

    public void setConcepto(String concepto) {
        this.concepto = concepto;
    }

    public Estado getEstado() {
        return estado;
    }

    public void setEstado(Estado estado) {
        this.estado = estado;
    }

    public Date getVencimiento() {
        return vencimiento;
    }

    public void setVencimiento(Date vencimiento) {
        this.vencimiento = vencimiento;
    }

    @Override
    public String toString() {
        return "Operaciones [" +
                "id=" + id +
                ", tipo=" + tipo +
                ", vendedor=" + vendedor +
                ", comprador=" + comprador +
                ", moneda=" + moneda +
                ", importe=" + importe +
                ", concepto=" + concepto +
                ", devolucion=" + devolucion +
                ", idOperacionOriginal=" + idOperacionOriginal +
                ", estado=" + estado +
                ", vencimiento=" + vencimiento +
                ']';
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;

        Operaciones that = (Operaciones) o;

        if (id != null ? !id.equals(that.id) : that.id != null) return false;
        if (tipo != that.tipo) return false;
        if (vendedor != null ? !vendedor.equals(that.vendedor) : that.vendedor != null) return false;
        if (comprador != null ? !comprador.equals(that.comprador) : that.comprador != null) return false;
        if (moneda != that.moneda) return false;
        if (importe != null ? !importe.equals(that.importe) : that.importe != null) return false;
        if (concepto != null ? !concepto.equals(that.concepto) : that.concepto != null) return false;
        if (devolucion != null ? !devolucion.equals(that.devolucion) : that.devolucion != null) return false;
        if (idOperacionOriginal != null ? !idOperacionOriginal.equals(that.idOperacionOriginal) : that.idOperacionOriginal != null) return false;
        if (estado != null ? !estado.equals(that.estado) : that.estado != null) return false;
        return vencimiento != null ? vencimiento.equals(that.vencimiento) : that.vencimiento == null;
    }

    @Override
    public int hashCode() {
        int result = id != null ? id.hashCode() : 0;
        result = 31 * result + (tipo != null ? tipo.hashCode() : 0);
        result = 31 * result + (vendedor != null ? vendedor.hashCode() : 0);
        result = 31 * result + (comprador != null ? comprador.hashCode() : 0);
        result = 31 * result + (moneda != null ? moneda.hashCode() : 0);
        result = 31 * result + (importe != null ? importe.hashCode() : 0);
        result = 31 * result + (concepto != null ? concepto.hashCode() : 0);
        result = 31 * result + (devolucion != null ? devolucion.hashCode() : 0);
        result = 31 * result + (idOperacionOriginal != null ? idOperacionOriginal.hashCode() : 0);
        result = 31 * result + (estado != null ? estado.hashCode() : 0);
        result = 31 * result + (vencimiento != null ? vencimiento.hashCode() : 0);
        return result;
    }
}
