package ar.com.sdd.debin.entity;

import ar.com.sdd.debin.core.DebinConst;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;

@JsonIgnoreProperties(ignoreUnknown = true)
public class TitularAlias {

    private DebinConst.TipoPersonaAlias tipo_persona;
    private String cuit;
    private String nombre;

    public TitularAlias() {

    }

    public DebinConst.TipoPersonaAlias getTipo_persona() {
        return tipo_persona;
    }

    public void setTipo_persona(DebinConst.TipoPersonaAlias tipo_persona) {
        this.tipo_persona = tipo_persona;
    }

    public String getCuit() {
        return cuit;
    }

    public void setCuit(String cuit) {
        this.cuit = cuit;
    }

    public String getNombre() {
        return nombre;
    }

    public void setNombre(String nombre) {
        this.nombre = nombre;
    }

    @Override
    public String toString() {
        return "TitularAlias [" +
                "tipo_persona=" + tipo_persona +
                ", cuit=" + cuit +
                ", nombre=" + nombre +
                ']';
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;

        TitularAlias that = (TitularAlias) o;

        if (tipo_persona != that.tipo_persona) return false;
        if (cuit != null ? !cuit.equals(that.cuit) : that.cuit != null) return false;
        return nombre != null ? nombre.equals(that.nombre) : that.nombre == null;
    }

    @Override
    public int hashCode() {
        int result = tipo_persona != null ? tipo_persona.hashCode() : 0;
        result = 31 * result + (cuit != null ? cuit.hashCode() : 0);
        result = 31 * result + (nombre != null ? nombre.hashCode() : 0);
        return result;
    }
}
