package ar.com.sdd.debin.io;

import ar.com.sdd.debin.entity.Comprador;
import ar.com.sdd.debin.entity.OperacionOriginal;
import ar.com.sdd.debin.entity.Vendedor;
import javax.json.bind.annotation.JsonbDateFormat;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import javax.json.bind.annotation.JsonbNillable;

import java.util.Date;

@JsonIgnoreProperties(ignoreUnknown = true)
@JsonbNillable
public class AvisoDeContracargoRequest {

    private OperacionOriginal operacionOriginal;
    private String id;

    @JsonbDateFormat("yyyy-MM-dd")
    private Date fechaNegocio;
    private Comprador comprador;
    private Vendedor vendedor;

    public AvisoDeContracargoRequest() {
    }

    public OperacionOriginal getOperacionOriginal() {
        return operacionOriginal;
    }

    public void setOperacionOriginal(OperacionOriginal operacionOriginal) {
        this.operacionOriginal = operacionOriginal;
    }

    public String getId() {
        return id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public Date getFechaNegocio() {
        return fechaNegocio;
    }

    public void setFechaNegocio(Date fechaNegocio) {
        this.fechaNegocio = fechaNegocio;
    }

    public Comprador getComprador() {
        return comprador;
    }

    public void setComprador(Comprador comprador) {
        this.comprador = comprador;
    }

    public Vendedor getVendedor() {
        return vendedor;
    }

    public void setVendedor(Vendedor vendedor) {
        this.vendedor = vendedor;
    }

    @Override
    public String toString() {
        return "AvisoDeContracargoRequest ["
                + ((operacionOriginal != null) ? "operacionOriginal=" + operacionOriginal + ", " : "")
                + ((id != null) ? "id=" + id + ", " : "")
                + ((fechaNegocio != null) ? "fechaNegocio=" + fechaNegocio + ", " : "")
                + ((comprador != null) ? "comprador=" + comprador + ", " : "")
                + ((vendedor != null) ? "vendedor=" + vendedor : "")
                + "]";
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;

        AvisoDeContracargoRequest that = (AvisoDeContracargoRequest) o;

        if (operacionOriginal != null ? !operacionOriginal.equals(that.operacionOriginal) : that.operacionOriginal != null) return false;
        if (id != null ? !id.equals(that.id) : that.id != null) return false;
        if (fechaNegocio != null ? !fechaNegocio.equals(that.fechaNegocio) : that.fechaNegocio != null) return false;
        if (comprador != null ? !comprador.equals(that.comprador) : that.comprador != null) return false;
        return vendedor != null ? vendedor.equals(that.vendedor) : that.vendedor == null;
    }

    @Override
    public int hashCode() {
        int result = operacionOriginal != null ? operacionOriginal.hashCode() : 0;
        result = 31 * result + (id != null ? id.hashCode() : 0);
        result = 31 * result + (fechaNegocio != null ? fechaNegocio.hashCode() : 0);
        result = 31 * result + (comprador != null ? comprador.hashCode() : 0);
        result = 31 * result + (vendedor != null ? vendedor.hashCode() : 0);
        return result;
    }
}
