package ar.com.sdd.debin.io;

import ar.com.sdd.debin.entity.Listado;
import ar.com.sdd.debin.entity.Recurrencia;
import ar.com.sdd.debin.entity.Respuesta;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import javax.json.bind.annotation.JsonbNillable;

import java.util.Arrays;
import java.util.Collection;

@JsonIgnoreProperties(ignoreUnknown = true)
@JsonbNillable
public class CompradorRecurrenciaListaCompradorResponse {

    private Respuesta respuesta;
    private Listado listado;
    private Collection<Recurrencia> recurrencia;

    public CompradorRecurrenciaListaCompradorResponse() {
    }

    public Respuesta getRespuesta() {
        return respuesta;
    }

    public void setRespuesta(Respuesta respuesta) {
        this.respuesta = respuesta;
    }

    public Listado getListado() {
        return listado;
    }

    public void setListado(Listado listado) {
        this.listado = listado;
    }

    public Collection<Recurrencia> getRecurrencia() {
        return recurrencia;
    }

    public void setRecurrencia(Collection<Recurrencia> recurrencia) {
        this.recurrencia = recurrencia;
    }

    @Override
    public String toString() {
        return "CompradorRecurrenciaListaCompradorResponse ["
                + ((respuesta != null) ? "respuesta=" + respuesta + ", " : "")
                + ((listado != null) ? "listado=" + listado + ", " : "")
                + ((recurrencia != null) ? "recurrencia=" + Arrays.toString(recurrencia.toArray()) : "")
                + "]";
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;

        CompradorRecurrenciaListaCompradorResponse that = (CompradorRecurrenciaListaCompradorResponse) o;

        if (respuesta != null ? !respuesta.equals(that.respuesta) : that.respuesta != null) return false;
        if (listado != null ? !listado.equals(that.listado) : that.listado != null) return false;
        return recurrencia != null ? recurrencia.equals(that.recurrencia) : that.recurrencia == null;
    }

    @Override
    public int hashCode() {
        int result = respuesta != null ? respuesta.hashCode() : 0;
        result = 31 * result + (listado != null ? listado.hashCode() : 0);
        result = 31 * result + (recurrencia != null ? recurrencia.hashCode() : 0);
        return result;
    }
}
