package ar.com.sdd.debin.io;

import ar.com.sdd.debin.entity.Estado;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import javax.json.bind.annotation.JsonbNillable;

@JsonIgnoreProperties(ignoreUnknown=true)
@JsonbNillable
public class EstablecerModoBancoRequest {

    private Estado estado;

    public EstablecerModoBancoRequest() {
    }

    public EstablecerModoBancoRequest(Estado estado) {
        this.estado = estado;
    }

    public Estado getEstado() {
        return estado;
    }

    public void setEstado(Estado estado) {
        this.estado = estado;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;

        EstablecerModoBancoRequest that = (EstablecerModoBancoRequest) o;

        return estado != null ? estado.equals(that.estado) : that.estado == null;
    }

    @Override
    public int hashCode() {
        return estado != null ? estado.hashCode() : 0;
    }

    @Override
    public String toString() {
        return "EstablecerModoBancoRequest [" +
                "estado=" + estado +
                ']';
    }
}
