package ar.com.sdd.debin.io;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import javax.json.bind.annotation.JsonbNillable;

@JsonIgnoreProperties(ignoreUnknown = true)
@JsonbNillable
public class LimitesConsultaVendedorRequest {

    private String cuit;

    public LimitesConsultaVendedorRequest() {
    }

    public LimitesConsultaVendedorRequest(String cuit) {
        this.cuit = cuit;
    }

    public String getCuit() {
        return cuit;
    }

    public void setCuit(String cuit) {
        this.cuit = cuit;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;

        LimitesConsultaVendedorRequest that = (LimitesConsultaVendedorRequest) o;

        return cuit != null ? cuit.equals(that.cuit) : that.cuit == null;
    }

    @Override
    public int hashCode() {
        return cuit != null ? cuit.hashCode() : 0;
    }

    @Override
    public String toString() {
        return "LimitesConsultaVendedorRequest [" +
                "cuit=" + cuit +
                ']';
    }
}
