package ar.com.sdd.debin.io;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import javax.json.bind.annotation.JsonbNillable;

@JsonIgnoreProperties(ignoreUnknown = true)
@JsonbNillable
public class LimitesModificarVendedorResponse {

    private String descripcion;
    /**
        4100 = LIMITES CREADOS/MODIFICADOS CON EXITO
        4153 = CANTIDAD INCORRECTA(DOLAR)
        4154 = IMPORTE INCORRECTO(DOLAR)
        4155 = CANTIDAD INCORRECTA(PESOS)
        4156 = IMPORTE INCORRECTO(PESOS)
        4157 = CUIT INEXISTENTE
        4158 = CUIT MAL FORMULADO
        4159 = LIMITES NO CREADOS/MODIFICADOS, ERROR DE DATOS
        4199 = ERROR GENERAL - CREACION DE LIMITES
     */
    private String codigo;

    public LimitesModificarVendedorResponse() {
    }

    public String getDescripcion() {
        return descripcion;
    }

    public void setDescripcion(String descripcion) {
        this.descripcion = descripcion;
    }

    public String getCodigo() {
        return codigo;
    }

    public void setCodigo(String codigo) {
        this.codigo = codigo;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;

        LimitesModificarVendedorResponse that = (LimitesModificarVendedorResponse) o;

        if (descripcion != null ? !descripcion.equals(that.descripcion) : that.descripcion != null) return false;
        return codigo != null ? codigo.equals(that.codigo) : that.codigo == null;
    }

    @Override
    public int hashCode() {
        int result = descripcion != null ? descripcion.hashCode() : 0;
        result = 31 * result + (codigo != null ? codigo.hashCode() : 0);
        return result;
    }

    @Override
    public String toString() {
        return "LimitesModificarVendedorResponse [" +
                "descripcion=" + descripcion +
                ", codigo=" + codigo +
                ']';
    }
}
