package ar.com.sdd.debin.io.apibancos;

import ar.com.sdd.debin.entity.*;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;

import javax.json.bind.annotation.JsonbNillable;

@JsonIgnoreProperties(ignoreUnknown = true)
@JsonbNillable
public class AvisoOperacionFinalizadaRequest {

    private Respuesta resultado;
    private Operacion operacion;
    private Comprador comprador;
    private Vendedor vendedor;
    private Debin debin;

    public AvisoOperacionFinalizadaRequest() {
    }

    public Comprador getComprador() {
        return comprador;
    }

    public void setComprador(Comprador comprador) {
        this.comprador = comprador;
    }

    public Vendedor getVendedor() {
        return vendedor;
    }

    public void setVendedor(Vendedor vendedor) {
        this.vendedor = vendedor;
    }

    public Debin getDebin() {
        return debin;
    }

    public void setDebin(Debin debin) {
        this.debin = debin;
    }

    public Operacion getOperacion() {
        return operacion;
    }

    public void setOperacion(Operacion operacion) {
        this.operacion = operacion;
    }

    public Respuesta getResultado() {
        return resultado;
    }

    public void setResultado(Respuesta resultado) {
        this.resultado = resultado;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;

        AvisoOperacionFinalizadaRequest that = (AvisoOperacionFinalizadaRequest) o;

        if (resultado != null ? !resultado.equals(that.resultado) : that.resultado != null) return false;
        if (operacion != null ? !operacion.equals(that.operacion) : that.operacion != null) return false;
        if (comprador != null ? !comprador.equals(that.comprador) : that.comprador != null) return false;
        if (vendedor != null ? !vendedor.equals(that.vendedor) : that.vendedor != null) return false;
        return debin != null ? debin.equals(that.debin) : that.debin == null;
    }

    @Override
    public int hashCode() {
        int result = resultado != null ? resultado.hashCode() : 0;
        result = 31 * result + (operacion != null ? operacion.hashCode() : 0);
        result = 31 * result + (comprador != null ? comprador.hashCode() : 0);
        result = 31 * result + (vendedor != null ? vendedor.hashCode() : 0);
        result = 31 * result + (debin != null ? debin.hashCode() : 0);
        return result;
    }

    @Override
    public String toString() {
        return "AvisoOperacionFinalizadaRequest [" +
                "resultado=" + resultado +
                ", operacion=" + operacion +
                ", comprador=" + comprador +
                ", vendedor=" + vendedor +
                ", debin=" + debin +
                ']';
    }
}
