package ar.com.sdd.debin.io;

import ar.com.sdd.debin.entity.Debito;
import ar.com.sdd.debin.entity.Importe;
import ar.com.sdd.debin.entity.Respuesta;
import ar.com.sdd.debin.util.ManyMillisecondsDateDeserializer;
import ar.com.sdd.debin.util.ManyMillisecondsDateSerializer;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.*;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;


import java.util.Date;

@JsonIgnoreProperties(ignoreUnknown = true)
@JsonInclude(JsonInclude.Include.NON_NULL)
public class OrdenDeDebitoCompradorResponse {

    private Respuesta respuesta;
    private Debito debito;
    private Importe importe;

    @JsonDeserialize(using = ManyMillisecondsDateDeserializer.class)
    @JsonSerialize(using = ManyMillisecondsDateSerializer.class)
    private Date fechaHoraEjecucion;

    public OrdenDeDebitoCompradorResponse() {

    }

    public Respuesta getRespuesta() {
        return respuesta;
    }

    public void setRespuesta(Respuesta respuesta) {
        this.respuesta = respuesta;
    }

    public Debito getDebito() {
        return debito;
    }

    public void setDebito(Debito debito) {
        this.debito = debito;
    }

    public Importe getImporte() {
        return importe;
    }

    public void setImporte(Importe importe) {
        this.importe = importe;
    }

    public Date getFechaHoraEjecucion() {
        return fechaHoraEjecucion;
    }

    public void setFechaHoraEjecucion(Date fechaHoraEjecucion) {
        this.fechaHoraEjecucion = fechaHoraEjecucion;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;

        OrdenDeDebitoCompradorResponse that = (OrdenDeDebitoCompradorResponse) o;

        if (respuesta != null ? !respuesta.equals(that.respuesta) : that.respuesta != null) return false;
        if (debito != null ? !debito.equals(that.debito) : that.debito != null) return false;
        if (importe != null ? !importe.equals(that.importe) : that.importe != null) return false;
        return fechaHoraEjecucion != null ? fechaHoraEjecucion.equals(that.fechaHoraEjecucion) : that.fechaHoraEjecucion == null;
    }

    @Override
    public int hashCode() {
        int result = respuesta != null ? respuesta.hashCode() : 0;
        result = 31 * result + (debito != null ? debito.hashCode() : 0);
        result = 31 * result + (importe != null ? importe.hashCode() : 0);
        result = 31 * result + (fechaHoraEjecucion != null ? fechaHoraEjecucion.hashCode() : 0);
        return result;
    }

    @Override
    public String toString() {
        return "OrdenDeDebitoCompradorResponse [" +
                "respuesta=" + respuesta +
                ", debito=" + debito +
                ", importe=" + importe +
                ", fechaHoraEjecucion=" + fechaHoraEjecucion +
                ']';
    }
}
