package ar.com.sdd.debin.io;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.*;

@JsonIgnoreProperties(ignoreUnknown = true)
@JsonInclude(JsonInclude.Include.NON_NULL)
public class CompradorRecurrenciaCompradorRequest {

    private Integer id;
    private String cuit;

    public CompradorRecurrenciaCompradorRequest() {}

    public Integer getId() {
        return id;
    }

    public void setId(Integer id) {
        this.id = id;
    }

    public String getCuit() {
        return cuit;
    }

    public void setCuit(String cuit) {
        this.cuit = cuit;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;

        CompradorRecurrenciaCompradorRequest that = (CompradorRecurrenciaCompradorRequest) o;

        if (id != null ? !id.equals(that.id) : that.id != null) return false;
        return cuit != null ? cuit.equals(that.cuit) : that.cuit == null;
    }

    @Override
    public int hashCode() {
        int result = id != null ? id.hashCode() : 0;
        result = 31 * result + (cuit != null ? cuit.hashCode() : 0);
        return result;
    }

    @Override
    public String toString() {
        return "CompradorRecurrenciaCompradorRequest [" +
                "id=" + id +
                ", cuit=" + cuit +
                ']';
    }
}
