package ar.com.sdd.debin.io;

import ar.com.sdd.debin.entity.Recurrencia;
import ar.com.sdd.debin.entity.Respuesta;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.*;

import java.util.Arrays;
import java.util.Collection;

@JsonIgnoreProperties(ignoreUnknown = true)
@JsonInclude(JsonInclude.Include.NON_NULL)
public class VendedorRecurrenciaVendedorResponse {

    private Respuesta respuesta;
    //Segun la documentacion, viene una sola
    private Collection<Recurrencia> recurrencia;

    public VendedorRecurrenciaVendedorResponse() {
    }

    public Respuesta getRespuesta() {
        return respuesta;
    }

    public void setRespuesta(Respuesta respuesta) {
        this.respuesta = respuesta;
    }

    public Collection<Recurrencia> getRecurrencia() {
        return recurrencia;
    }

    public void setRecurrencia(Collection<Recurrencia> recurrencia) {
        this.recurrencia = recurrencia;
    }

    @Override
    public String toString() {
        return "VendedorRecurrenciaVendedorResponse ["
                + ((respuesta != null) ? "respuesta=" + respuesta + ", " : "")
                + ((recurrencia != null) ? "recurrencia=" + Arrays.toString(recurrencia.toArray()) : "")
                + "]";
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;

        VendedorRecurrenciaVendedorResponse that = (VendedorRecurrenciaVendedorResponse) o;

        if (respuesta != null ? !respuesta.equals(that.respuesta) : that.respuesta != null) return false;
        return recurrencia != null ? recurrencia.equals(that.recurrencia) : that.recurrencia == null;
    }

    @Override
    public int hashCode() {
        int result = respuesta != null ? respuesta.hashCode() : 0;
        result = 31 * result + (recurrencia != null ? recurrencia.hashCode() : 0);
        return result;
    }
}
