package ar.com.sdd.debin.entity;

import ar.com.sdd.debin.core.DebinConst;
import com.fasterxml.jackson.annotation.JsonFormat;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;

import java.math.BigDecimal;
import java.util.Date;

@JsonIgnoreProperties(ignoreUnknown = true)
public class OperacionCvu {

    private String id;
    private DebinConst.TipoDebin tipo;
    private String concepto;
    private String cbu;
    @JsonFormat(shape = JsonFormat.Shape.STRING, pattern = "yyyy-MM-dd", timezone = "GMT-03:00")
    private Date fecha_negocio;
    private DebinConst.Moneda moneda;
    private BigDecimal importe;
    private String id_psp;
    private String cuit_psp;
    private String cvu;
    private String cuit_cvu;
    private String titular_cvu;
    private String ori_trx;
    private String ori_adicional;

    public String getId() {
        return id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public DebinConst.TipoDebin getTipo() {
        return tipo;
    }

    public void setTipo(DebinConst.TipoDebin tipo) {
        this.tipo = tipo;
    }

    public String getConcepto() {
        return concepto;
    }

    public void setConcepto(String concepto) {
        this.concepto = concepto;
    }

    public String getCbu() {
        return cbu;
    }

    public void setCbu(String cbu) {
        this.cbu = cbu;
    }

    public Date getFecha_negocio() {
        return fecha_negocio;
    }

    public void setFecha_negocio(Date fecha_negocio) {
        this.fecha_negocio = fecha_negocio;
    }

    public DebinConst.Moneda getMoneda() {
        return moneda;
    }

    public void setMoneda(DebinConst.Moneda moneda) {
        this.moneda = moneda;
    }

    public BigDecimal getImporte() {
        return importe;
    }

    public void setImporte(BigDecimal importe) {
        this.importe = importe;
    }

    public String getId_psp() {
        return id_psp;
    }

    public void setId_psp(String id_psp) {
        this.id_psp = id_psp;
    }

    public String getCuit_psp() {
        return cuit_psp;
    }

    public void setCuit_psp(String cuit_psp) {
        this.cuit_psp = cuit_psp;
    }

    public String getCvu() {
        return cvu;
    }

    public void setCvu(String cvu) {
        this.cvu = cvu;
    }

    public String getCuit_cvu() {
        return cuit_cvu;
    }

    public void setCuit_cvu(String cuit_cvu) {
        this.cuit_cvu = cuit_cvu;
    }

    public String getTitular_cvu() {
        return titular_cvu;
    }

    public void setTitular_cvu(String titular_cvu) {
        this.titular_cvu = titular_cvu;
    }

    public String getOri_trx() {
        return ori_trx;
    }

    public void setOri_trx(String ori_trx) {
        this.ori_trx = ori_trx;
    }

    public String getOri_adicional() {
        return ori_adicional;
    }

    public void setOri_adicional(String ori_adicional) {
        this.ori_adicional = ori_adicional;
    }

    @Override
    public String toString() {
        return "OperacionCvu ["
                + ((id != null) ? "id=" + id + ", " : "")
                + ((tipo != null) ? "tipo=" + tipo + ", " : "")
                + ((concepto != null) ? "concepto=" + concepto + ", " : "")
                + ((cbu != null) ? "cbu=" + cbu + ", " : "")
                + ((fecha_negocio != null) ? "fecha_negocio=" + fecha_negocio + ", " : "")
                + ((moneda != null) ? "moneda=" + moneda + ", " : "")
                + ((importe != null) ? "importe=" + importe + ", " : "")
                + ((id_psp != null) ? "id_psp=" + id_psp + ", " : "")
                + ((cuit_psp != null) ? "cuit_psp=" + cuit_psp + ", " : "")
                + ((cvu != null) ? "cvu=" + cvu + ", " : "")
                + ((cuit_cvu != null) ? "cuit_cvu=" + cuit_cvu + ", " : "")
                + ((titular_cvu != null) ? "titular_cvu=" + titular_cvu + ", " : "")
                + ((ori_trx != null) ? "ori_trx=" + ori_trx + ", " : "")
                + ((ori_adicional != null) ? "ori_adicional=" + ori_adicional : "")
                + "]";
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;

        OperacionCvu that = (OperacionCvu) o;

        if (id != null ? !id.equals(that.id) : that.id != null) return false;
        if (tipo != that.tipo) return false;
        if (concepto != null ? !concepto.equals(that.concepto) : that.concepto != null) return false;
        if (cbu != null ? !cbu.equals(that.cbu) : that.cbu != null) return false;
        if (fecha_negocio != null ? !fecha_negocio.equals(that.fecha_negocio) : that.fecha_negocio != null)
            return false;
        if (moneda != that.moneda) return false;
        if (importe != null ? !importe.equals(that.importe) : that.importe != null) return false;
        if (id_psp != null ? !id_psp.equals(that.id_psp) : that.id_psp != null) return false;
        if (cuit_psp != null ? !cuit_psp.equals(that.cuit_psp) : that.cuit_psp != null) return false;
        if (cvu != null ? !cvu.equals(that.cvu) : that.cvu != null) return false;
        if (cuit_cvu != null ? !cuit_cvu.equals(that.cuit_cvu) : that.cuit_cvu != null) return false;
        if (titular_cvu != null ? !titular_cvu.equals(that.titular_cvu) : that.titular_cvu != null) return false;
        if (ori_trx != null ? !ori_trx.equals(that.ori_trx) : that.ori_trx != null) return false;
        return ori_adicional != null ? ori_adicional.equals(that.ori_adicional) : that.ori_adicional == null;
    }

    @Override
    public int hashCode() {
        int result = id != null ? id.hashCode() : 0;
        result = 31 * result + (tipo != null ? tipo.hashCode() : 0);
        result = 31 * result + (concepto != null ? concepto.hashCode() : 0);
        result = 31 * result + (cbu != null ? cbu.hashCode() : 0);
        result = 31 * result + (fecha_negocio != null ? fecha_negocio.hashCode() : 0);
        result = 31 * result + (moneda != null ? moneda.hashCode() : 0);
        result = 31 * result + (importe != null ? importe.hashCode() : 0);
        result = 31 * result + (id_psp != null ? id_psp.hashCode() : 0);
        result = 31 * result + (cuit_psp != null ? cuit_psp.hashCode() : 0);
        result = 31 * result + (cvu != null ? cvu.hashCode() : 0);
        result = 31 * result + (cuit_cvu != null ? cuit_cvu.hashCode() : 0);
        result = 31 * result + (titular_cvu != null ? titular_cvu.hashCode() : 0);
        result = 31 * result + (ori_trx != null ? ori_trx.hashCode() : 0);
        result = 31 * result + (ori_adicional != null ? ori_adicional.hashCode() : 0);
        return result;
    }
}
