package ar.com.sdd.debin.util;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.ser.std.StdSerializer;

import javax.xml.bind.DatatypeConverter;
import java.io.IOException;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;

/**
 * Serializa una fecha hacia el formato que usa Coelsa <br>
 * Ejemplo tomado de: https://kodejava.org/tag/jsondeserialize/ <br>
 * Ver notas en {@link ManyMillisecondsDateDeserializer#deserialize(JsonParser, DeserializationContext)}
 */
public class ManyMillisecondsDateSerializer extends StdSerializer<Date> {

    public ManyMillisecondsDateSerializer() {
        super(Date.class);
    }

    @Override
    public void serialize(Date date, JsonGenerator jsonGenerator, SerializerProvider serializerProvider) throws IOException {
        if (date != null) {
            Calendar cal = new GregorianCalendar();
            cal.setTime(date);
            jsonGenerator.writeString(DatatypeConverter.printDateTime(cal));
        }
    }
}
