package ar.com.sdd.debin.io.apibancos;

import ar.com.sdd.debin.entity.Comprador;
import ar.com.sdd.debin.entity.Operacion;
import ar.com.sdd.debin.entity.Respuesta;
import ar.com.sdd.debin.entity.Vendedor;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;

import com.fasterxml.jackson.annotation.*;

/**
 * Esta clase antes representaba el AvisoDebinFinalizado
 */
@JsonIgnoreProperties(ignoreUnknown = true)
@JsonInclude(JsonInclude.Include.NON_NULL)
public class ResultadoProcesoDebinRequest {

    private Respuesta resultado;
    private Operacion operacion;
    private Comprador comprador;
    private Vendedor vendedor;

    public Respuesta getResultado() {
        return resultado;
    }

    public void setResultado(Respuesta resultado) {
        this.resultado = resultado;
    }

    public Operacion getOperacion() {
        return operacion;
    }

    public void setOperacion(Operacion operacion) {
        this.operacion = operacion;
    }

    public Comprador getComprador() {
        return comprador;
    }

    public void setComprador(Comprador comprador) {
        this.comprador = comprador;
    }

    public Vendedor getVendedor() {
        return vendedor;
    }

    public void setVendedor(Vendedor vendedor) {
        this.vendedor = vendedor;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;

        ResultadoProcesoDebinRequest that = (ResultadoProcesoDebinRequest) o;

        if (resultado != null ? !resultado.equals(that.resultado) : that.resultado != null) return false;
        if (operacion != null ? !operacion.equals(that.operacion) : that.operacion != null) return false;
        if (comprador != null ? !comprador.equals(that.comprador) : that.comprador != null) return false;
        return vendedor != null ? vendedor.equals(that.vendedor) : that.vendedor == null;
    }

    @Override
    public int hashCode() {
        int result = resultado != null ? resultado.hashCode() : 0;
        result = 31 * result + (operacion != null ? operacion.hashCode() : 0);
        result = 31 * result + (comprador != null ? comprador.hashCode() : 0);
        result = 31 * result + (vendedor != null ? vendedor.hashCode() : 0);
        return result;
    }

    @Override
    public String toString() {
        return "ResultadoProcesoDebinRequest [" +
                "resultado=" + resultado +
                ", operacion=" + operacion +
                ", comprador=" + comprador +
                ", vendedor=" + vendedor +
                ']';
    }
}
