package ar.com.sdd.debin.entity;

import ar.com.sdd.debin.core.DebinConst;

import com.fasterxml.jackson.annotation.*;

@JsonInclude(JsonInclude.Include.NON_NULL)
public class Objeto {

    private DebinConst.TipoDebin tipo;
    private String id;
    private Boolean preautorizado;
    private String ori_trx;
    private String ori_terminal;
    private String ori_adicional;
    private Integer ori_trx_id;
    private Estado estado;

    public Objeto() {

    }

    public DebinConst.TipoDebin getTipo() {
        return tipo;
    }

    public void setTipo(DebinConst.TipoDebin tipo) {
        this.tipo = tipo;
    }

    public Boolean getPreautorizado() {
        return preautorizado;
    }

    public void setPreautorizado(Boolean preautorizado) {
        this.preautorizado = preautorizado;
    }

    public String getId() {
        return id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getOri_trx() {
        return ori_trx;
    }

    public void setOri_trx(String ori_trx) {
        this.ori_trx = ori_trx;
    }

    public String getOri_terminal() {
        return ori_terminal;
    }

    public void setOri_terminal(String ori_terminal) {
        this.ori_terminal = ori_terminal;
    }

    public String getOri_adicional() {
        return ori_adicional;
    }

    public void setOri_adicional(String ori_adicional) {
        this.ori_adicional = ori_adicional;
    }

    public Estado getEstado() {
        return estado;
    }

    public void setEstado(Estado estado) {
        this.estado = estado;
    }

    public Integer getOri_trx_id() {
        return ori_trx_id;
    }

    public void setOri_trx_id(Integer ori_trx_id) {
        this.ori_trx_id = ori_trx_id;
    }


    @Override
    public String toString() {
        return "Objeto [" +
                "tipo=" + tipo +
                ", id=" + id +
                ", preautorizado=" + preautorizado +
                ", ori_trx=" + ori_trx +
                ", ori_terminal=" + ori_terminal +
                ", ori_adicional=" + ori_adicional +
                ", ori_trx_id=" + ori_trx_id +
                ", estado=" + estado +
                ']';
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;

        Objeto objeto = (Objeto) o;

        if (tipo != objeto.tipo) return false;
        if (id != null ? !id.equals(objeto.id) : objeto.id != null) return false;
        if (preautorizado != null ? !preautorizado.equals(objeto.preautorizado) : objeto.preautorizado != null) return false;
        if (ori_trx != null ? !ori_trx.equals(objeto.ori_trx) : objeto.ori_trx != null) return false;
        if (ori_terminal != null ? !ori_terminal.equals(objeto.ori_terminal) : objeto.ori_terminal != null) return false;
        if (ori_adicional != null ? !ori_adicional.equals(objeto.ori_adicional) : objeto.ori_adicional != null) return false;
        if (ori_trx_id != null ? !ori_trx_id.equals(objeto.ori_trx_id) : objeto.ori_trx_id != null) return false;
        return estado != null ? estado.equals(objeto.estado) : objeto.estado == null;
    }

    @Override
    public int hashCode() {
        int result = tipo != null ? tipo.hashCode() : 0;
        result = 31 * result + (id != null ? id.hashCode() : 0);
        result = 31 * result + (preautorizado != null ? preautorizado.hashCode() : 0);
        result = 31 * result + (ori_trx != null ? ori_trx.hashCode() : 0);
        result = 31 * result + (ori_terminal != null ? ori_terminal.hashCode() : 0);
        result = 31 * result + (ori_adicional != null ? ori_adicional.hashCode() : 0);
        result = 31 * result + (ori_trx_id != null ? ori_trx_id.hashCode() : 0);
        result = 31 * result + (estado != null ? estado.hashCode() : 0);
        return result;
    }
}
