package ar.com.sdd.debin.log;

import ar.com.sdd.debin.core.DebinConnector;
import com.fasterxml.jackson.databind.ObjectMapper;
import org.apache.commons.io.IOUtils;
import org.apache.log4j.Logger;

import javax.ws.rs.container.ContainerRequestContext;
import javax.ws.rs.container.ContainerRequestFilter;
import javax.ws.rs.container.ContainerResponseContext;
import javax.ws.rs.container.ContainerResponseFilter;
import javax.ws.rs.ext.Provider;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.nio.charset.StandardCharsets;


/*



            **********************************
            Habria que mudarse al RestConnector
            **********************************


 */

@ServerLogged
@Provider
public class ServerLogginFilter implements ContainerRequestFilter, ContainerResponseFilter {

    private static final Logger log = Logger.getLogger(ServerLogginFilter.class);
    private static final Logger logAll = Logger.getLogger("ar.com.sdd.commons.rest.log.LogAll");

    /**
     * Request filter
     *
     * @param requestContext
     * @throws IOException
     */
    @Override
    public void filter(ContainerRequestContext requestContext) throws IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        IOUtils.copy(requestContext.getEntityStream(), baos);
        byte[] bytes = baos.toByteArray();

        String payload = new String(bytes, StandardCharsets.UTF_8);
        String respuesta = "[" + DebinConnector.getCacheSafeValue() + "]:[DebinRESTServer] Server Request - Method [" + requestContext.getMethod() + "], URI [" + requestContext.getUriInfo().getRequestUri() + "]:";
        logAll.trace(respuesta + payload);
        if (payload.length() > DebinConnector.MAX_ENTITY_SIZE) {
            payload = payload.substring(0, DebinConnector.MAX_ENTITY_SIZE) + "...more...";
        }
        log.info(respuesta + payload);
        requestContext.setEntityStream(new ByteArrayInputStream(bytes));
    }

    /**
     * Response filter
     *
     * @param requestContext
     * @param responseContext
     * @throws IOException
     */
    @Override
    public void filter(ContainerRequestContext requestContext, ContainerResponseContext responseContext) throws IOException {

        String respuesta = "[" + DebinConnector.getCacheSafeValue() + "]:[DebinRESTServer] Server Response - Method [" + requestContext.getMethod() + "], Status [" + responseContext.getStatus() + "], URI [" + requestContext.getUriInfo().getRequestUri() + "]:";
        Object entity = responseContext.getEntity();
        if (entity != null) {
            String payload = new ObjectMapper().writerWithDefaultPrettyPrinter().writeValueAsString(entity);
            logAll.trace(respuesta + payload);
            if (payload.length() > DebinConnector.MAX_ENTITY_SIZE) {
                payload = payload.substring(0, DebinConnector.MAX_ENTITY_SIZE) + "...more...";
            }
            log.info(respuesta + payload);
        } else {
            logAll.trace(respuesta + "(vacio)");
            log.info(respuesta + "(vacio)");
        }
    }
}
