package ar.com.sdd.debin.entity;

import ar.com.sdd.debin.util.ManyMillisecondsDateDeserializer;
import ar.com.sdd.debin.util.ManyMillisecondsDateSerializer;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;


import java.util.Date;

@JsonIgnoreProperties(ignoreUnknown=true)
public class Creacion {

    @JsonDeserialize(using = ManyMillisecondsDateDeserializer.class)
    @JsonSerialize(using = ManyMillisecondsDateSerializer.class)
    private Date fechaDesde;

    @JsonDeserialize(using = ManyMillisecondsDateDeserializer.class)
    @JsonSerialize(using = ManyMillisecondsDateSerializer.class)
    private Date fechaHasta;

    public Date getFechaDesde() {
        return fechaDesde;
    }

    public void setFechaDesde(Date fechaDesde) {
        this.fechaDesde = fechaDesde;
    }

    public Date getFechaHasta() {
        return fechaHasta;
    }

    public void setFechaHasta(Date fechaHasta) {
        this.fechaHasta = fechaHasta;
    }

    @Override
    public String toString() {
        return "Creacion [" +
                "fechaDesde=" + fechaDesde +
                ", fechaHasta=" + fechaHasta +
                ']';
    }
}
