package ar.com.sdd.debin.rest;

import ar.com.sdd.debin.core.DebinException;
import ar.com.sdd.debin.core.DebinRestProxy;
import ar.com.sdd.debin.io.AvisoAdhesionRecurrenciaRequest;
import ar.com.sdd.debin.io.AvisoDeContracargoRequest;
import ar.com.sdd.debin.io.AvisoTransaccionRequest;
import ar.com.sdd.debin.io.apibancos.*;
import ar.com.sdd.debin.log.ServerLogged;
import org.apache.log4j.Logger;

import javax.inject.Inject;
import javax.ws.rs.*;
import javax.ws.rs.core.Response;

@Path("/")
public class DebinRestEndpoint  {

    @Inject private DebinRestProxy debinRestProxy;

    private static final Logger log = Logger.getLogger(DebinRestEndpoint.class);

    @POST
    @ServerLogged
    @Path("/AvisoDebinPendiente")
    @Consumes("application/json")
    public Response avisoDebinPendiente(AvisoDebinPendienteRequest request) {
        if (debinRestProxy == null) throw new RuntimeException("No se ha inicializado el DebinRestProxy");
        log.trace("Post server request [" + request + "]");
        try {
            debinRestProxy.avisoDebinPendiente(request);
            return Response.status(Response.Status.OK).build();
        } catch (DebinException e) {
            return Response.status(Response.Status.INTERNAL_SERVER_ERROR).entity(e.getMessage()).build();
        }
    }

    @POST
    @ServerLogged
    @Path("/ResultadoProcesoDebin")
    @Consumes("application/json")
    public Response resultadoProcesoDebin(ResultadoProcesoDebinRequest request) {
        //Antes era AvisoDebinFinalizado
        if (debinRestProxy == null) throw new RuntimeException("No se ha inicializado el DebinRestProxy");
        log.trace("Post server request [" + request + "]");
        try {
            debinRestProxy.resultadoProcesoDebin(request);
            return Response.status(Response.Status.OK).build();
        } catch (DebinException e) {
            return Response.status(Response.Status.INTERNAL_SERVER_ERROR).entity(e.getMessage()).build();
        }
    }

    @POST
    @ServerLogged
    @Path("/Credito")
    @Consumes("application/json")
    @Produces("application/json")
    public Response credito(CreditoRequest request) {
        if (debinRestProxy == null) throw new RuntimeException("No se ha inicializado el DebinRestProxy");
        log.trace("Post server request [" + request + "]");
        try {
            CreditoResponse response = debinRestProxy.credito(request);
            log.trace("Post server response [" + response + "]");
            return Response.status(Response.Status.OK).entity(response).build();
        } catch (DebinException e) {
            return Response.status(Response.Status.INTERNAL_SERVER_ERROR).entity(e.getMessage()).build();
        }
    }

    @POST
    @ServerLogged
    @Path("/Debito")
    @Consumes("application/json")
    @Produces("application/json")
    public Response debito(DebitoRequest request) {
        if (debinRestProxy == null) throw new RuntimeException("No se ha inicializado el DebinRestProxy");
        log.trace("Post server request [" + request + "]");
        try {
            DebitoResponse response = debinRestProxy.debito(request);
            log.trace("Post server response [" + response + "]");
            return Response.status(Response.Status.OK).entity(response).build();
        } catch (DebinException e) {
            return Response.status(Response.Status.INTERNAL_SERVER_ERROR).entity(e.getMessage()).build();
        }
    }

    @POST
    @ServerLogged
    @Path("/AvisoOperacionFinalizada")
    @Consumes("application/json")
    public Response avisoOperacionFinalizada(AvisoOperacionFinalizadaRequest request) {
        if (debinRestProxy == null) throw new RuntimeException("No se ha inicializado el DebinRestProxy");
        log.trace("Post server request [" + request + "]");
        try {
            debinRestProxy.avisoOperacionFinalizada(request);
            return Response.status(Response.Status.OK).build();
        } catch (DebinException e) {
            return Response.status(Response.Status.INTERNAL_SERVER_ERROR).entity(e.getMessage()).build();
        }
    }

    @POST
    @ServerLogged
    @Path("/ResultadoCredito")
    @Consumes("application/json")
    public Response resultadoCredito(ResultadoCreditoRequest request) {
        if (debinRestProxy == null) throw new RuntimeException("No se ha inicializado el DebinRestProxy");
        log.trace("Post server request [" + request + "]");
        try {
            debinRestProxy.resultadoCredito(request);
            return Response.status(Response.Status.OK).build();
        } catch (DebinException e) {
            return Response.status(Response.Status.INTERNAL_SERVER_ERROR).entity(e.getMessage()).build();
        }
    }

    @POST
    @ServerLogged
    @Path("/AvisoAdhesionRecurrencia")
    @Consumes("application/json")
    public Response avisoAdhesionRecurrencia(AvisoAdhesionRecurrenciaRequest request) {
        if (debinRestProxy == null) throw new RuntimeException("No se ha inicializado el DebinRestProxy");
        log.trace("Post server request [" + request + "]");
        try {
            debinRestProxy.avisoAdhesionRecurrencia(request);
            return Response.status(Response.Status.OK).build();
        } catch (DebinException e) {
            return Response.status(Response.Status.INTERNAL_SERVER_ERROR).entity(e.getMessage()).build();
        }
    }

    @POST
    @ServerLogged
    @Path("/AvisoDeContracargo")
    @Consumes("application/json")
    public Response avisoDeContracargo(AvisoDeContracargoRequest request) {
        if (debinRestProxy == null) throw new RuntimeException("No se ha inicializado el DebinRestProxy");
        log.trace("Post server request [" + request + "]");
        try {
            debinRestProxy.avisoDeContracargo(request);
            return Response.status(Response.Status.OK).build();
        } catch (DebinException e) {
            return Response.status(Response.Status.INTERNAL_SERVER_ERROR).entity(e.getMessage()).build();
        }
    }

    /**
     * Operacion para informar una CVU
     * @param request
     * @return
     */
    @POST
    @ServerLogged
    @Path("/AvisoTransaccion")
    @Consumes("application/json")
    public Response avisoTransaccion(AvisoTransaccionRequest request) {
        if (debinRestProxy == null) throw new RuntimeException("No se ha inicializado el DebinRestProxy");
        log.trace("Post server request [" + request + "]");
        try {
            debinRestProxy.avisoTransaccion(request);
            return Response.status(Response.Status.OK).build();
        } catch (DebinException e) {
            return Response.status(Response.Status.INTERNAL_SERVER_ERROR).entity(e.getMessage()).build();
        }
    }

    @GET
    @ServerLogged
    @Path("/Echo")
    public Response echo() {
        log.trace("Post server request []");
        return Response.status(200).build();
    }

}
