package ar.com.sdd.debin.io;


import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.*;

@JsonIgnoreProperties(ignoreUnknown=true)
@JsonInclude(JsonInclude.Include.NON_NULL)
public class ConfirmarDebitoResponse {

    private String descripcion;
    /**
     * Debin/ConfirmaDebito
     * 00: Ok
     * 23: No coinciden el CBU enviado. REVERSAR
     * 25: No coincide el CUIT enviado. REVERSAR
     * 27: No coincide el tipo de moneda. REVERSAR
     * 29: No coincide el importe enviado. REVERSAR
     * 80: Banco de token no permitido. REVERSAR
     * 46: DEBIN Expirado. REVERSAR
     * 99: Error de Sistema. REVERSAR
     * 31: El banco débito no posee garantías suficientes. REVERSAR
     * 03: El DEBIN fue eliminado. REVERSAR
     * 83: El DEBIN no existe. REVERSAR
     * 87: El DEBIN se encuentra en un estado que no permite su modificación. REVERSAR
     */
    private String codigo;
    private String fechaNegocio;

    public String getDescripcion() {
        return descripcion;
    }

    public void setDescripcion(String descripcion) {
        this.descripcion = descripcion;
    }

    public String getCodigo() {
        return codigo;
    }

    public void setCodigo(String codigo) {
        this.codigo = codigo;
    }

    public String getFechaNegocio() {
        return fechaNegocio;
    }

    public void setFechaNegocio(String fechaNegocio) {
        this.fechaNegocio = fechaNegocio;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;

        ConfirmarDebitoResponse that = (ConfirmarDebitoResponse) o;

        if (descripcion != null ? !descripcion.equals(that.descripcion) : that.descripcion != null) return false;
        if (codigo != null ? !codigo.equals(that.codigo) : that.codigo != null) return false;
        return fechaNegocio != null ? fechaNegocio.equals(that.fechaNegocio) : that.fechaNegocio == null;
    }

    @Override
    public int hashCode() {
        int result = descripcion != null ? descripcion.hashCode() : 0;
        result = 31 * result + (codigo != null ? codigo.hashCode() : 0);
        result = 31 * result + (fechaNegocio != null ? fechaNegocio.hashCode() : 0);
        return result;
    }

    @Override
    public String toString() {
        return "ConfirmarDebitoResponse [" +
                "descripcion=" + descripcion +
                ", codigo=" + codigo +
                ", fechaNegocio=" + fechaNegocio +
                ']';
    }
}
