package ar.com.sdd.debin.io;

import ar.com.sdd.debin.entity.Cuenta;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;

@JsonIgnoreProperties(ignoreUnknown=true)
@JsonInclude(JsonInclude.Include.NON_NULL)
public class AltaCuentaEspecialBancoRequest {

    private Cuenta cuenta;
    private Boolean activo;

    public AltaCuentaEspecialBancoRequest() {
    }

    public Cuenta getCuenta() {
        return cuenta;
    }

    public void setCuenta(Cuenta cuenta) {
        this.cuenta = cuenta;
    }

    public Boolean getActivo() {
        return activo;
    }

    public void setActivo(Boolean activo) {
        this.activo = activo;
    }

    @Override
    public String toString() {
        return "AltaCuentaEspecialBancoRequest ["
                + ((cuenta != null) ? "cuenta=" + cuenta + ", " : "")
                + ((activo != null) ? "activo=" + activo : "")
                + "]";
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;

        AltaCuentaEspecialBancoRequest that = (AltaCuentaEspecialBancoRequest) o;

        if (cuenta != null ? !cuenta.equals(that.cuenta) : that.cuenta != null) return false;
        return activo != null ? activo.equals(that.activo) : that.activo == null;
    }

    @Override
    public int hashCode() {
        int result = cuenta != null ? cuenta.hashCode() : 0;
        result = 31 * result + (activo != null ? activo.hashCode() : 0);
        return result;
    }
}
