package ar.com.sdd.debin.io;

import ar.com.sdd.debin.entity.OperacionCvu;
import ar.com.sdd.debin.entity.Originante;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;

@JsonIgnoreProperties(ignoreUnknown = true)
@JsonInclude(JsonInclude.Include.NON_NULL)
public class AvisoTransaccionRequest {

    private OperacionCvu operacionCvu;
    private Originante originante;

    public AvisoTransaccionRequest() {
    }

    @JsonProperty("operacionCVU")
    public OperacionCvu getOperacionCvu() {
        return operacionCvu;
    }

    @JsonProperty("operacionCVU")
    public void setOperacionCvu(OperacionCvu operacionCvu) {
        this.operacionCvu = operacionCvu;
    }

    public Originante getOriginante() {
        return originante;
    }

    public void setOriginante(Originante originante) {
        this.originante = originante;
    }

    @Override
    public String toString() {
        return "AvisoTransaccionRequest ["
                + ((operacionCvu != null) ? "operacionCvu=" + operacionCvu + ", " : "")
                + ((originante != null) ? "originante=" + originante : "")
                + "]";
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;

        AvisoTransaccionRequest that = (AvisoTransaccionRequest) o;

        if (operacionCvu != null ? !operacionCvu.equals(that.operacionCvu) : that.operacionCvu != null) return false;
        return originante != null ? originante.equals(that.originante) : that.originante == null;
    }

    @Override
    public int hashCode() {
        int result = operacionCvu != null ? operacionCvu.hashCode() : 0;
        result = 31 * result + (originante != null ? originante.hashCode() : 0);
        return result;
    }
}
