package ar.com.sdd.debin.entity;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;

@JsonIgnoreProperties(ignoreUnknown=true)
public class Listado {

    private Integer tamano;
    private Integer pagina;
    private Integer paginasTotales;

    public Integer getPaginasTotales() {
        return paginasTotales;
    }

    public void setPaginasTotales(Integer paginasTotales) {
        this.paginasTotales = paginasTotales;
    }

    public Integer getTamano() {
        return tamano;
    }

    public void setTamano(Integer tamano) {
        this.tamano = tamano;
    }

    public Integer getPagina() {
        return pagina;
    }

    public void setPagina(Integer pagina) {
        this.pagina = pagina;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;

        Listado listado = (Listado) o;

        if (tamano != null ? !tamano.equals(listado.tamano) : listado.tamano != null) return false;
        if (pagina != null ? !pagina.equals(listado.pagina) : listado.pagina != null) return false;
        return paginasTotales != null ? paginasTotales.equals(listado.paginasTotales) : listado.paginasTotales == null;
    }

    @Override
    public int hashCode() {
        int result = tamano != null ? tamano.hashCode() : 0;
        result = 31 * result + (pagina != null ? pagina.hashCode() : 0);
        result = 31 * result + (paginasTotales != null ? paginasTotales.hashCode() : 0);
        return result;
    }

    @Override
    public String toString() {
        return "Listado [" +
                "tamano=" + tamano +
                ", pagina=" + pagina +
                ", paginasTotales=" + paginasTotales +
                ']';
    }
}
