package ar.com.sdd.debin.io;

import ar.com.sdd.debin.entity.DatosGenerador;
import ar.com.sdd.debin.entity.Operacion;
import ar.com.sdd.debin.entity.Respuesta;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.*;

@JsonIgnoreProperties(ignoreUnknown=true)
@JsonInclude(JsonInclude.Include.NON_NULL)
public class ConfirmarDebitoRequest {

    private String id;
    private Operacion operacion;
    private Respuesta respuesta;
    private DatosGenerador datosGenerador;

    public Operacion getOperacion() {
        return operacion;
    }

    public void setOperacion(Operacion operacion) {
        this.operacion = operacion;
    }

    public String getId() {
        return id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public Respuesta getRespuesta() {
        return respuesta;
    }

    public void setRespuesta(Respuesta respuesta) {
        this.respuesta = respuesta;
    }

    public DatosGenerador getDatosGenerador() {
        return datosGenerador;
    }

    public void setDatosGenerador(DatosGenerador datosGenerador) {
        this.datosGenerador = datosGenerador;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;

        ConfirmarDebitoRequest that = (ConfirmarDebitoRequest) o;

        if (id != null ? !id.equals(that.id) : that.id != null) return false;
        if (operacion != null ? !operacion.equals(that.operacion) : that.operacion != null) return false;
        if (respuesta != null ? !respuesta.equals(that.respuesta) : that.respuesta != null) return false;
        return datosGenerador != null ? datosGenerador.equals(that.datosGenerador) : that.datosGenerador == null;
    }

    @Override
    public int hashCode() {
        int result = id != null ? id.hashCode() : 0;
        result = 31 * result + (operacion != null ? operacion.hashCode() : 0);
        result = 31 * result + (respuesta != null ? respuesta.hashCode() : 0);
        result = 31 * result + (datosGenerador != null ? datosGenerador.hashCode() : 0);
        return result;
    }

    @Override
    public String toString() {
        return "ConfirmarDebitoRequest [" +
                "id=" + id +
                ", operacion=" + operacion +
                ", respuesta=" + respuesta +
                ", datosGenerador=" + datosGenerador +
                ']';
    }
}
