package ar.com.sdd.debin.io;

import ar.com.sdd.debin.entity.Listado;
import ar.com.sdd.debin.entity.Respuesta;
import ar.com.sdd.debin.entity.Vendedor;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;

import java.util.Arrays;
import java.util.Collection;

@JsonIgnoreProperties(ignoreUnknown = true)
@JsonInclude(JsonInclude.Include.NON_NULL)
public class VendedorListadoVendedorResponse {

    private Respuesta respuesta;
    private Listado listado;
    private Collection<Vendedor> vendedores;

    public VendedorListadoVendedorResponse() {
    }

    public Respuesta getRespuesta() {
        return respuesta;
    }

    public void setRespuesta(Respuesta respuesta) {
        this.respuesta = respuesta;
    }

    public Listado getListado() {
        return listado;
    }

    public void setListado(Listado listado) {
        this.listado = listado;
    }

    public Collection<Vendedor> getVendedores() {
        return vendedores;
    }

    public void setVendedores(Collection<Vendedor> vendedores) {
        this.vendedores = vendedores;
    }

    @Override
    public String toString() {
        return "VendedorListadoVendedorResponse ["
                + ((respuesta != null) ? "respuesta=" + respuesta + ", " : "")
                + ((listado != null) ? "listado=" + listado + ", " : "")
                + ((vendedores != null) ? "vendedores=" + Arrays.toString(vendedores.toArray()) : "")
                + "]";
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;

        VendedorListadoVendedorResponse that = (VendedorListadoVendedorResponse) o;

        if (respuesta != null ? !respuesta.equals(that.respuesta) : that.respuesta != null) return false;
        if (listado != null ? !listado.equals(that.listado) : that.listado != null) return false;
        return vendedores != null ? vendedores.equals(that.vendedores) : that.vendedores == null;
    }

    @Override
    public int hashCode() {
        int result = respuesta != null ? respuesta.hashCode() : 0;
        result = 31 * result + (listado != null ? listado.hashCode() : 0);
        result = 31 * result + (vendedores != null ? vendedores.hashCode() : 0);
        return result;
    }
}
