package ar.com.sdd.debin.entity;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;

@JsonIgnoreProperties(ignoreUnknown = true)
public class Prestacion {

    private String nombre;
    private String ayuda_referencia;
    private Integer min;
    private Integer max;

    public Prestacion() {

    }

    public String getNombre() {
        return nombre;
    }

    public void setNombre(String nombre) {
        this.nombre = nombre;
    }

    public String getAyuda_referencia() {
        return ayuda_referencia;
    }

    public void setAyuda_referencia(String ayuda_referencia) {
        this.ayuda_referencia = ayuda_referencia;
    }

    public Integer getMin() {
        return min;
    }

    public void setMin(Integer min) {
        this.min = min;
    }

    public Integer getMax() {
        return max;
    }

    public void setMax(Integer max) {
        this.max = max;
    }

    @Override
    public String toString() {
        return "Prestacion ["
                + ((nombre != null) ? "nombre=" + nombre + ", " : "")
                + ((ayuda_referencia != null) ? "ayuda_referencia=" + ayuda_referencia + ", " : "")
                + ((min != null) ? "min=" + min + ", " : "")
                + ((max != null) ? "max=" + max : "")
                + "]";
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;

        Prestacion that = (Prestacion) o;

        if (nombre != null ? !nombre.equals(that.nombre) : that.nombre != null) return false;
        if (ayuda_referencia != null ? !ayuda_referencia.equals(that.ayuda_referencia) : that.ayuda_referencia != null)
            return false;
        if (min != null ? !min.equals(that.min) : that.min != null) return false;
        return max != null ? max.equals(that.max) : that.max == null;
    }

    @Override
    public int hashCode() {
        int result = nombre != null ? nombre.hashCode() : 0;
        result = 31 * result + (ayuda_referencia != null ? ayuda_referencia.hashCode() : 0);
        result = 31 * result + (min != null ? min.hashCode() : 0);
        result = 31 * result + (max != null ? max.hashCode() : 0);
        return result;
    }
}
