package ar.com.sdd.debin.entity;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;

@JsonIgnoreProperties(ignoreUnknown = true)
public class Alias {

    private String valor;
    private String valor_original;
    private String id;

    public Alias() {

    }

    public String getValor() {
        return valor;
    }

    public void setValor(String valor) {
        this.valor = valor;
    }

    public String getValor_original() {
        return valor_original;
    }

    public void setValor_original(String valor_original) {
        this.valor_original = valor_original;
    }

    public String getId() {
        return id;
    }

    public void setId(String id) {
        this.id = id;
    }

    @Override
    public String toString() {
        return "Alias [" +
                "valor=" + valor +
                ", valor_original=" + valor_original +
                ", id=" + id +
                ']';
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;

        Alias alias = (Alias) o;

        if (valor != null ? !valor.equals(alias.valor) : alias.valor != null) return false;
        if (valor_original != null ? !valor_original.equals(alias.valor_original) : alias.valor_original != null) return false;
        return id != null ? id.equals(alias.id) : alias.id == null;
    }

    @Override
    public int hashCode() {
        int result = valor != null ? valor.hashCode() : 0;
        result = 31 * result + (valor_original != null ? valor_original.hashCode() : 0);
        result = 31 * result + (id != null ? id.hashCode() : 0);
        return result;
    }
}
