package ar.com.sdd.debin.entity;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;

import java.util.Arrays;
import java.util.Collection;

@JsonIgnoreProperties(ignoreUnknown = true)
public class VendedorConsumos {

    private String cuit;
    private String impMaxGlobalARS;
    private String cantMaxGlobalARS;
    private String impMaxGlobalDLS;
    private String cantMaxGlobalDLS;
    private Collection<ConsumoBanco> consumosBanco;

    public VendedorConsumos() {
    }

    public String getCuit() {
        return cuit;
    }

    public void setCuit(String cuit) {
        this.cuit = cuit;
    }

    public String getImpMaxGlobalARS() {
        return impMaxGlobalARS;
    }

    public void setImpMaxGlobalARS(String impMaxGlobalARS) {
        this.impMaxGlobalARS = impMaxGlobalARS;
    }

    public String getCantMaxGlobalARS() {
        return cantMaxGlobalARS;
    }

    public void setCantMaxGlobalARS(String cantMaxGlobalARS) {
        this.cantMaxGlobalARS = cantMaxGlobalARS;
    }

    public String getImpMaxGlobalDLS() {
        return impMaxGlobalDLS;
    }

    public void setImpMaxGlobalDLS(String impMaxGlobalDLS) {
        this.impMaxGlobalDLS = impMaxGlobalDLS;
    }

    public String getCantMaxGlobalDLS() {
        return cantMaxGlobalDLS;
    }

    public void setCantMaxGlobalDLS(String cantMaxGlobalDLS) {
        this.cantMaxGlobalDLS = cantMaxGlobalDLS;
    }

    public Collection<ConsumoBanco> getConsumosBanco() {
        return consumosBanco;
    }

    public void setConsumosBanco(Collection<ConsumoBanco> consumosBanco) {
        this.consumosBanco = consumosBanco;
    }

    @Override
    public String toString() {
        return "VendedorConsumos ["
                + ((cuit != null) ? "cuit=" + cuit + ", " : "")
                + ((impMaxGlobalARS != null) ? "impMaxGlobalARS=" + impMaxGlobalARS + ", " : "")
                + ((cantMaxGlobalARS != null) ? "cantMaxGlobalARS=" + cantMaxGlobalARS + ", " : "")
                + ((impMaxGlobalDLS != null) ? "impMaxGlobalDLS=" + impMaxGlobalDLS + ", " : "")
                + ((cantMaxGlobalDLS != null) ? "cantMaxGlobalDLS=" + cantMaxGlobalDLS + ", " : "")
                + ((consumosBanco != null) ? "consumosBanco=" + Arrays.toString(consumosBanco.toArray()) : "")
                + "]";
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;

        VendedorConsumos that = (VendedorConsumos) o;

        if (cuit != null ? !cuit.equals(that.cuit) : that.cuit != null) return false;
        if (impMaxGlobalARS != null ? !impMaxGlobalARS.equals(that.impMaxGlobalARS) : that.impMaxGlobalARS != null) return false;
        if (cantMaxGlobalARS != null ? !cantMaxGlobalARS.equals(that.cantMaxGlobalARS) : that.cantMaxGlobalARS != null) return false;
        if (impMaxGlobalDLS != null ? !impMaxGlobalDLS.equals(that.impMaxGlobalDLS) : that.impMaxGlobalDLS != null) return false;
        if (cantMaxGlobalDLS != null ? !cantMaxGlobalDLS.equals(that.cantMaxGlobalDLS) : that.cantMaxGlobalDLS != null) return false;
        return consumosBanco != null ? consumosBanco.equals(that.consumosBanco) : that.consumosBanco == null;
    }

    @Override
    public int hashCode() {
        int result = cuit != null ? cuit.hashCode() : 0;
        result = 31 * result + (impMaxGlobalARS != null ? impMaxGlobalARS.hashCode() : 0);
        result = 31 * result + (cantMaxGlobalARS != null ? cantMaxGlobalARS.hashCode() : 0);
        result = 31 * result + (impMaxGlobalDLS != null ? impMaxGlobalDLS.hashCode() : 0);
        result = 31 * result + (cantMaxGlobalDLS != null ? cantMaxGlobalDLS.hashCode() : 0);
        result = 31 * result + (consumosBanco != null ? consumosBanco.hashCode() : 0);
        return result;
    }
}
